/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree;

import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.lang.LighterASTTokenNode;
import com.intellij.lang.LighterLazyParseableNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.SmartList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LightTreeUtil {
    private LightTreeUtil() {
    }

    @Nullable
    public static LighterASTNode firstChildOfType(@NotNull LighterAST tree, @NotNull LighterASTNode node, @NotNull IElementType type) {
        List children2 = tree.getChildren(node);
        return LightTreeUtil.firstChildOfType((List<LighterASTNode>)children2, type);
    }

    @Nullable
    public static LighterASTNode firstChildOfType(@NotNull List<LighterASTNode> children2, @NotNull IElementType type) {
        for (int i = 0; i < children2.size(); ++i) {
            LighterASTNode child = children2.get(i);
            if (child.getTokenType() != type) continue;
            return child;
        }
        return null;
    }

    @Nullable
    public static LighterASTNode firstChildOfType(@NotNull LighterAST tree, @NotNull LighterASTNode node, @NotNull TokenSet types) {
        List children2 = tree.getChildren(node);
        return LightTreeUtil.firstChildOfType((List<LighterASTNode>)children2, types);
    }

    @Nullable
    public static LighterASTNode firstChildOfType(@NotNull List<LighterASTNode> children2, @NotNull TokenSet types) {
        for (int i = 0; i < children2.size(); ++i) {
            LighterASTNode child = children2.get(i);
            if (!types.contains(child.getTokenType())) continue;
            return child;
        }
        return null;
    }

    @NotNull
    public static LighterASTNode requiredChildOfType(@NotNull LighterAST tree, @NotNull LighterASTNode node, @NotNull IElementType type) {
        LighterASTNode child = LightTreeUtil.firstChildOfType(tree, node, type);
        assert (child != null) : "Required child " + type + " not found in " + node.getTokenType() + ": " + tree.getChildren(node);
        return child;
    }

    @NotNull
    public static LighterASTNode requiredChildOfType(@NotNull LighterAST tree, @NotNull LighterASTNode node, @NotNull TokenSet types) {
        LighterASTNode child = LightTreeUtil.firstChildOfType(tree, node, types);
        assert (child != null) : "Required child " + types + " not found in " + node.getTokenType() + ": " + tree.getChildren(node);
        return child;
    }

    @NotNull
    public static List<LighterASTNode> getChildrenOfType(@NotNull LighterAST tree, @NotNull LighterASTNode node, @NotNull IElementType type) {
        SmartList result = null;
        List children2 = tree.getChildren(node);
        int size = children2.size();
        for (int i = 0; i < size; ++i) {
            LighterASTNode child = (LighterASTNode)children2.get(i);
            if (child.getTokenType() != type) continue;
            if (result == null) {
                result = new SmartList();
            }
            result.add((LighterASTNode)child);
        }
        return result != null ? result : Collections.emptyList();
    }

    @NotNull
    public static List<LighterASTNode> getChildrenOfType(@NotNull LighterAST tree, @NotNull LighterASTNode node, @NotNull TokenSet types) {
        List children2 = tree.getChildren(node);
        return LightTreeUtil.getChildrenOfType(children2, types);
    }

    @NotNull
    public static List<LighterASTNode> getChildrenOfType(List<LighterASTNode> children2, @NotNull TokenSet types) {
        SmartList result = null;
        int size = children2.size();
        for (int i = 0; i < size; ++i) {
            LighterASTNode child = children2.get(i);
            if (!types.contains(child.getTokenType())) continue;
            if (result == null) {
                result = new SmartList();
            }
            result.add((LighterASTNode)child);
        }
        return result != null ? result : Collections.emptyList();
    }

    @NotNull
    public static String toFilteredString(@NotNull LighterAST tree, @NotNull LighterASTNode node, @Nullable TokenSet skipTypes) {
        int length = node.getEndOffset() - node.getStartOffset();
        if (length < 0) {
            length = 0;
            Logger.getInstance(LightTreeUtil.class).error("tree=" + tree + " node=" + node);
        }
        StringBuilder buffer = new StringBuilder(length);
        LightTreeUtil.toBuffer(tree, node, buffer, skipTypes);
        return buffer.toString();
    }

    public static void toBuffer(@NotNull LighterAST tree, @NotNull LighterASTNode node, @NotNull StringBuilder buffer, @Nullable TokenSet skipTypes) {
        if (skipTypes != null && skipTypes.contains(node.getTokenType())) {
            return;
        }
        if (node instanceof LighterASTTokenNode) {
            buffer.append(((LighterASTTokenNode)node).getText());
            return;
        }
        if (node instanceof LighterLazyParseableNode) {
            buffer.append(((LighterLazyParseableNode)node).getText());
            return;
        }
        List children2 = tree.getChildren(node);
        int size = children2.size();
        for (int i = 0; i < size; ++i) {
            LightTreeUtil.toBuffer(tree, (LighterASTNode)children2.get(i), buffer, skipTypes);
        }
        tree.disposeChildren(children2);
    }
}

