/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree;

import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectCoreUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.CheckUtil;
import com.intellij.psi.impl.ResolveScopeManager;
import com.intellij.psi.impl.SharedPsiElementImplUtil;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.impl.source.tree.ChangeUtil;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.LazyParseableElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LazyParseablePsiElement
extends LazyParseableElement
implements PsiElement,
NavigationItem {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.tree.LazyParseablePsiElement");

    public LazyParseablePsiElement(@NotNull IElementType type, CharSequence buffer) {
        super(type, buffer);
        this.setPsi(this);
    }

    @Override
    @NotNull
    public LazyParseablePsiElement clone() {
        LazyParseablePsiElement clone = (LazyParseablePsiElement)super.clone();
        clone.setPsi(clone);
        return clone;
    }

    @NotNull
    public PsiElement[] getChildren() {
        return this.getChildrenAsPsiElements(null, PsiElement.ARRAY_FACTORY);
    }

    @Nullable
    protected <T> T findChildByClass(Class<T> aClass) {
        for (PsiElement cur = this.getFirstChild(); cur != null; cur = cur.getNextSibling()) {
            if (!aClass.isInstance(cur)) continue;
            return (T)cur;
        }
        return null;
    }

    @NotNull
    protected <T> T[] findChildrenByClass(Class<T> aClass) {
        ArrayList<PsiElement> result = new ArrayList<PsiElement>();
        for (PsiElement cur = this.getFirstChild(); cur != null; cur = cur.getNextSibling()) {
            if (!aClass.isInstance(cur)) continue;
            result.add(cur);
        }
        return result.toArray((Object[])Array.newInstance(aClass, result.size()));
    }

    public PsiElement getFirstChild() {
        TreeElement child = this.getFirstChildNode();
        if (child == null) {
            return null;
        }
        return child.getPsi();
    }

    public PsiElement getLastChild() {
        TreeElement child = this.getLastChildNode();
        if (child == null) {
            return null;
        }
        return child.getPsi();
    }

    public void acceptChildren(@NotNull PsiElementVisitor visitor) {
        for (PsiElement child = this.getFirstChild(); child != null; child = child.getNextSibling()) {
            child.accept(visitor);
        }
    }

    public PsiElement getParent() {
        CompositeElement treeParent = this.getTreeParent();
        if (treeParent == null) {
            return null;
        }
        if (treeParent instanceof PsiElement) {
            return (PsiElement)treeParent;
        }
        return treeParent.getPsi();
    }

    public PsiElement getNextSibling() {
        return SharedImplUtil.getNextSibling(this);
    }

    public PsiElement getPrevSibling() {
        return SharedImplUtil.getPrevSibling(this);
    }

    public PsiFile getContainingFile() {
        PsiFile file2 = SharedImplUtil.getContainingFile(this);
        if (file2 == null) {
            throw new PsiInvalidElementAccessException((PsiElement)this);
        }
        return file2;
    }

    public PsiElement findElementAt(int offset) {
        LeafElement leaf = this.findLeafElementAt(offset);
        return SourceTreeToPsiMap.treeElementToPsi(leaf);
    }

    public PsiReference findReferenceAt(int offset) {
        return SharedPsiElementImplUtil.findReferenceAt(this, offset);
    }

    public PsiElement copy() {
        ASTNode elementCopy = this.copyElement();
        return SourceTreeToPsiMap.treeElementToPsi(elementCopy);
    }

    public boolean isValid() {
        return SharedImplUtil.isValid(this);
    }

    public boolean isWritable() {
        return SharedImplUtil.isWritable(this);
    }

    public PsiReference getReference() {
        return null;
    }

    @NotNull
    public PsiReference[] getReferences() {
        return SharedPsiElementImplUtil.getReferences(this);
    }

    public PsiElement add(@NotNull PsiElement element) throws IncorrectOperationException {
        return this.addInnerBefore(element, null);
    }

    public PsiElement addBefore(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        return this.addInnerBefore(element, anchor);
    }

    public PsiElement addAfter(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        CheckUtil.checkWritable(this);
        TreeElement elementCopy = ChangeUtil.copyToElement(element);
        TreeElement treeElement = this.addInternal(elementCopy, elementCopy, SourceTreeToPsiMap.psiElementToTree(anchor), Boolean.FALSE);
        return ChangeUtil.decodeInformation(treeElement).getPsi();
    }

    public final void checkAdd(@NotNull PsiElement element) throws IncorrectOperationException {
        CheckUtil.checkWritable(this);
    }

    public final PsiElement addRange(PsiElement first, PsiElement last) throws IncorrectOperationException {
        return SharedImplUtil.addRange(this, first, last, null, null);
    }

    public final PsiElement addRangeBefore(@NotNull PsiElement first, @NotNull PsiElement last, PsiElement anchor) throws IncorrectOperationException {
        return SharedImplUtil.addRange(this, first, last, SourceTreeToPsiMap.psiElementToTree(anchor), Boolean.TRUE);
    }

    public final PsiElement addRangeAfter(PsiElement first, PsiElement last, PsiElement anchor) throws IncorrectOperationException {
        return SharedImplUtil.addRange(this, first, last, SourceTreeToPsiMap.psiElementToTree(anchor), Boolean.FALSE);
    }

    public void delete() throws IncorrectOperationException {
        LOG.assertTrue(this.getTreeParent() != null, (Object)("Parent not found for " + this));
        CheckUtil.checkWritable(this);
        this.getTreeParent().deleteChildInternal(this);
        this.invalidate();
    }

    public void checkDelete() throws IncorrectOperationException {
        CheckUtil.checkWritable(this);
    }

    public void deleteChildRange(PsiElement first, PsiElement last) throws IncorrectOperationException {
        CheckUtil.checkWritable(this);
        ASTNode firstElement = SourceTreeToPsiMap.psiElementToTree(first);
        ASTNode lastElement = SourceTreeToPsiMap.psiElementToTree(last);
        LOG.assertTrue(firstElement.getTreeParent() == this);
        LOG.assertTrue(lastElement.getTreeParent() == this);
        CodeEditUtil.removeChildren(this, firstElement, lastElement);
    }

    public PsiElement replace(@NotNull PsiElement newElement) throws IncorrectOperationException {
        return SharedImplUtil.doReplace(this, this, newElement);
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        visitor.visitElement((PsiElement)this);
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor2, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        return true;
    }

    @Override
    public String toString() {
        return "PsiElement(" + this.getElementType().toString() + ")";
    }

    public PsiElement getContext() {
        return this.getParent();
    }

    @NotNull
    public PsiElement getNavigationElement() {
        return this;
    }

    public PsiElement getOriginalElement() {
        return this;
    }

    public boolean isPhysical() {
        PsiFile file2 = this.getContainingFile();
        return file2 != null && file2.isPhysical();
    }

    @NotNull
    public GlobalSearchScope getResolveScope() {
        assert (this.isValid());
        return ResolveScopeManager.getElementResolveScope(this);
    }

    @NotNull
    public SearchScope getUseScope() {
        return ResolveScopeManager.getElementUseScope(this);
    }

    public ItemPresentation getPresentation() {
        return null;
    }

    public String getName() {
        return null;
    }

    public void navigate(boolean requestFocus) {
        PsiNavigationSupport.getInstance().getDescriptor((PsiElement)this).navigate(requestFocus);
    }

    public boolean canNavigate() {
        return PsiNavigationSupport.getInstance().canNavigate((PsiElement)this);
    }

    public boolean canNavigateToSource() {
        return this.canNavigate();
    }

    @NotNull
    public Project getProject() {
        Project project2 = ProjectCoreUtil.theOnlyOpenProject();
        if (project2 != null) {
            return project2;
        }
        PsiManager manager = this.getManager();
        if (manager == null) {
            throw new PsiInvalidElementAccessException((PsiElement)this);
        }
        return manager.getProject();
    }

    @NotNull
    public Language getLanguage() {
        return this.getElementType().getLanguage();
    }

    @NotNull
    public ASTNode getNode() {
        return this;
    }

    private PsiElement addInnerBefore(PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        CheckUtil.checkWritable(this);
        TreeElement elementCopy = ChangeUtil.copyToElement(element);
        TreeElement treeElement = this.addInternal(elementCopy, elementCopy, SourceTreeToPsiMap.psiElementToTree(anchor), Boolean.TRUE);
        if (treeElement != null) {
            return ChangeUtil.decodeInformation(treeElement).getPsi();
        }
        throw new IncorrectOperationException("Element cannot be added");
    }

    public boolean isEquivalentTo(PsiElement another) {
        return this == another;
    }
}

