/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.LogUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.ILazyParseableElementType;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.text.ImmutableCharSequence;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LazyParseableElement
extends CompositeElement {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.tree.LazyParseableElement");
    private final ChameleonLock lock = new ChameleonLock();
    private CharSequence myText;
    private static final ThreadLocal<Boolean> ourSuppressEagerPsiCreation = new ThreadLocal();
    private static boolean ourParsingAllowed = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LazyParseableElement(@NotNull IElementType type, @Nullable CharSequence text) {
        super(type);
        if (text != null) {
            ChameleonLock chameleonLock = this.lock;
            synchronized (chameleonLock) {
                this.myText = ImmutableCharSequence.asImmutable((CharSequence)text);
            }
            this.setCachedLength(text.length());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearCaches() {
        super.clearCaches();
        ChameleonLock chameleonLock = this.lock;
        synchronized (chameleonLock) {
            if (this.myText != null) {
                this.setCachedLength(this.myText.length());
            }
        }
    }

    @Override
    @NotNull
    public String getText() {
        CharSequence text = this.myText();
        if (text != null) {
            return text.toString();
        }
        return super.getText();
    }

    @Override
    @NotNull
    public CharSequence getChars() {
        CharSequence text = this.myText();
        if (text != null) {
            return text;
        }
        return super.getText();
    }

    @Override
    public int getTextLength() {
        CharSequence text = this.myText();
        if (text != null) {
            return text.length();
        }
        return super.getTextLength();
    }

    @Override
    public int getNotCachedLength() {
        CharSequence text = this.myText();
        if (text != null) {
            return text.length();
        }
        return super.getNotCachedLength();
    }

    @Override
    public int hc() {
        CharSequence text = this.myText();
        return text == null ? super.hc() : LeafElement.leafHC(text);
    }

    @Override
    protected int textMatches(@NotNull CharSequence buffer, int start) {
        CharSequence text = this.myText();
        if (text != null) {
            return LeafElement.leafTextMatches(text, buffer, start);
        }
        return super.textMatches(buffer, start);
    }

    public boolean isParsed() {
        return this.myText() == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CharSequence myText() {
        ChameleonLock chameleonLock = this.lock;
        synchronized (chameleonLock) {
            return this.myText;
        }
    }

    @Override
    final void setFirstChildNode(TreeElement child) {
        if (this.myText() != null) {
            LOG.error("Mutating collapsed chameleon");
        }
        super.setFirstChildNode(child);
    }

    @Override
    final void setLastChildNode(TreeElement child) {
        if (this.myText() != null) {
            LOG.error("Mutating collapsed chameleon");
        }
        super.setLastChildNode(child);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void ensureParsed() {
        ASTNode parsedNode;
        block14: {
            CharSequence text;
            if (!ourParsingAllowed) {
                LOG.error("Parsing not allowed!!!");
            }
            if ((text = this.myText()) == null) {
                return;
            }
            if (TreeUtil.getFileElement(this) == null) {
                LOG.error("Chameleons must not be parsed till they're in file tree: " + this);
            }
            ApplicationManager.getApplication().assertReadAccessAllowed();
            DebugUtil.startPsiModification("lazy-parsing");
            ILazyParseableElementType type = (ILazyParseableElementType)this.getElementType();
            parsedNode = type.parseContents((ASTNode)this);
            if (parsedNode == null && text.length() > 0) {
                CharSequence diagText = ApplicationManager.getApplication().isInternal() ? text : "";
                LOG.error("No parse for a non-empty string: " + diagText + "; type=" + LogUtil.objectAndClass((Object)type));
            }
            ChameleonLock chameleonLock = this.lock;
            // MONITORENTER : chameleonLock
            if (this.myText != null) break block14;
            // MONITOREXIT : chameleonLock
            DebugUtil.finishPsiModification();
            return;
        }
        if (this.rawFirstChild() != null) {
            LOG.error("Reentrant parsing?");
        }
        this.myText = null;
        if (parsedNode == null) {
            // MONITOREXIT : chameleonLock
            DebugUtil.finishPsiModification();
            return;
        }
        try {
            super.rawAddChildrenWithoutNotifications((TreeElement)parsedNode);
            // MONITOREXIT : chameleonLock
        }
        finally {
            DebugUtil.finishPsiModification();
        }
        if (Boolean.TRUE.equals(ourSuppressEagerPsiCreation.get())) return;
        this.createAllChildrenPsiIfNecessary();
    }

    @Override
    public void rawAddChildrenWithoutNotifications(@NotNull TreeElement first) {
        if (this.myText() != null) {
            LOG.error("Mutating collapsed chameleon");
        }
        super.rawAddChildrenWithoutNotifications(first);
    }

    @Override
    public TreeElement getFirstChildNode() {
        this.ensureParsed();
        return super.getFirstChildNode();
    }

    @Override
    public TreeElement getLastChildNode() {
        this.ensureParsed();
        return super.getLastChildNode();
    }

    public int copyTo(@Nullable char[] buffer, int start) {
        CharSequence text = this.myText();
        if (text == null) {
            return -1;
        }
        if (buffer != null) {
            CharArrayUtil.getChars((CharSequence)text, (char[])buffer, (int)start);
        }
        return start + text.length();
    }

    public static void setParsingAllowed(boolean allowed) {
        ourParsingAllowed = allowed;
    }

    public static void setSuppressEagerPsiCreation(boolean suppress) {
        ourSuppressEagerPsiCreation.set(suppress);
    }

    private static class ChameleonLock {
        private ChameleonLock() {
        }

        @NonNls
        public String toString() {
            return "chameleon parsing lock";
        }
    }
}

