/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree;

import com.intellij.lang.ASTNode;
import com.intellij.lang.FCTSBackedLighterAST;
import com.intellij.lang.FileASTNode;
import com.intellij.lang.LighterAST;
import com.intellij.lang.TreeBackedLighterAST;
import com.intellij.openapi.util.Getter;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.source.CharTableImpl;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.LazyParseableElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.ILightStubFileElementType;
import com.intellij.util.CharTable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileElement
extends LazyParseableElement
implements FileASTNode,
Getter<FileElement> {
    public static final FileElement[] EMPTY_ARRAY = new FileElement[0];
    private volatile CharTable myCharTable = new CharTableImpl();
    private volatile boolean myDetached;

    @Override
    protected PsiElement createPsiNoLock() {
        return this.myDetached ? null : super.createPsiNoLock();
    }

    public void detachFromFile() {
        this.myDetached = true;
        this.clearPsi();
    }

    @NotNull
    public CharTable getCharTable() {
        return this.myCharTable;
    }

    @Nullable
    public LighterAST getLighterAST() {
        IFileElementType contentType = (IFileElementType)this.getElementType();
        assert (contentType instanceof ILightStubFileElementType) : contentType;
        if (!this.isParsed()) {
            return new FCTSBackedLighterAST(this.getCharTable(), ((ILightStubFileElementType)contentType).parseContentsLight(this));
        }
        return new TreeBackedLighterAST((FileASTNode)this);
    }

    public FileElement(@NotNull IElementType type, CharSequence text) {
        super(type, text);
    }

    @Deprecated
    public FileElement(IElementType type) {
        super(type, null);
    }

    @Override
    public PsiManagerEx getManager() {
        CompositeElement treeParent = this.getTreeParent();
        if (treeParent != null) {
            return treeParent.getManager();
        }
        return (PsiManagerEx)this.getPsi().getManager();
    }

    @Override
    public ASTNode copyElement() {
        PsiFileImpl psiElement = (PsiFileImpl)this.getPsi();
        PsiFileImpl psiElementCopy = (PsiFileImpl)psiElement.copy();
        return psiElementCopy.getTreeElement();
    }

    public void setCharTable(@NotNull CharTable table) {
        this.myCharTable = table;
    }

    public FileElement get() {
        return this;
    }
}

