/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree;

import com.intellij.lang.ASTFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.DummyHolder;
import com.intellij.psi.impl.source.DummyHolderFactory;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.PsiErrorElementImpl;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.CharTable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Factory {
    private Factory() {
    }

    @NotNull
    public static LeafElement createSingleLeafElement(@NotNull IElementType type, CharSequence buffer, int startOffset, int endOffset, CharTable table, PsiManager manager, PsiFile originalFile) {
        DummyHolder dummyHolder = DummyHolderFactory.createHolder(manager, table, type.getLanguage());
        dummyHolder.setOriginalFile(originalFile);
        FileElement holderElement = dummyHolder.getTreeElement();
        LeafElement newElement = ASTFactory.leaf(type, holderElement.getCharTable().intern(buffer, startOffset, endOffset));
        holderElement.rawAddChildren(newElement);
        CodeEditUtil.setNodeGenerated(newElement, true);
        return newElement;
    }

    @NotNull
    public static LeafElement createSingleLeafElement(@NotNull IElementType type, CharSequence buffer, int startOffset, int endOffset, CharTable table, PsiManager manager, boolean generatedFlag) {
        FileElement holderElement = DummyHolderFactory.createHolder(manager, table, type.getLanguage()).getTreeElement();
        LeafElement newElement = ASTFactory.leaf(type, holderElement.getCharTable().intern(buffer, startOffset, endOffset));
        holderElement.rawAddChildren(newElement);
        if (generatedFlag) {
            CodeEditUtil.setNodeGenerated(newElement, true);
        }
        return newElement;
    }

    @NotNull
    public static LeafElement createSingleLeafElement(@NotNull IElementType type, CharSequence buffer, CharTable table, PsiManager manager) {
        return Factory.createSingleLeafElement(type, buffer, 0, buffer.length(), table, manager);
    }

    @NotNull
    public static LeafElement createSingleLeafElement(@NotNull IElementType type, CharSequence buffer, int startOffset, int endOffset, @Nullable CharTable table, PsiManager manager) {
        return Factory.createSingleLeafElement(type, buffer, startOffset, endOffset, table, manager, true);
    }

    @NotNull
    public static CompositeElement createErrorElement(String description) {
        return new PsiErrorElementImpl(description);
    }

    @NotNull
    public static CompositeElement createCompositeElement(@NotNull IElementType type, CharTable charTableByTree, PsiManager manager) {
        FileElement treeElement = DummyHolderFactory.createHolder(manager, null, charTableByTree).getTreeElement();
        CompositeElement composite = ASTFactory.composite(type);
        treeElement.rawAddChildren(composite);
        return composite;
    }
}

