/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.ForeignLeafPsiElement;
import com.intellij.psi.impl.source.tree.LazyParseableElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.RecursiveTreeElementWalkingVisitor;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.util.text.CharArrayCharSequence;
import com.intellij.util.text.StringFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AstBufferUtil {
    private AstBufferUtil() {
    }

    public static int toBuffer(@NotNull ASTNode element, @Nullable char[] buffer, int offset) {
        return AstBufferUtil.toBuffer(element, buffer, offset, false);
    }

    public static int toBuffer(@NotNull ASTNode element, @Nullable char[] buffer, int offset, boolean skipWhitespaceAndComments) {
        BufferVisitor visitor = new BufferVisitor(skipWhitespaceAndComments, skipWhitespaceAndComments, offset, buffer);
        ((TreeElement)element).acceptTree(visitor);
        return visitor.end;
    }

    public static String getTextSkippingWhitespaceComments(@NotNull ASTNode element) {
        int length = AstBufferUtil.toBuffer(element, null, 0, true);
        char[] buffer = new char[length];
        AstBufferUtil.toBuffer(element, buffer, 0, true);
        return StringFactory.createShared((char[])buffer);
    }

    public static class BufferVisitor
    extends RecursiveTreeElementWalkingVisitor {
        private final boolean skipWhitespace;
        private final boolean skipComments;
        protected final int offset;
        protected int end;
        protected final char[] buffer;

        public BufferVisitor(PsiElement element, boolean skipWhitespace, boolean skipComments) {
            this(skipWhitespace, skipComments, 0, new char[element.getTextLength()]);
            ((TreeElement)element.getNode()).acceptTree(this);
        }

        public BufferVisitor(boolean skipWhitespace, boolean skipComments, int offset, @Nullable char[] buffer) {
            super(false);
            this.skipWhitespace = skipWhitespace;
            this.skipComments = skipComments;
            this.buffer = buffer;
            this.offset = offset;
            this.end = offset;
        }

        public int getEnd() {
            return this.end;
        }

        public char[] getBuffer() {
            assert (this.buffer != null);
            return this.buffer;
        }

        public CharSequence createCharSequence() {
            assert (this.buffer != null);
            return new CharArrayCharSequence(this.buffer, this.offset, this.end);
        }

        @Override
        public void visitLeaf(LeafElement element) {
            ProgressIndicatorProvider.checkCanceled();
            if (!this.isIgnored(element)) {
                this.end = element.copyTo(this.buffer, this.end);
            }
        }

        protected boolean isIgnored(LeafElement element) {
            return element instanceof ForeignLeafPsiElement || this.skipWhitespace && element instanceof PsiWhiteSpace || this.skipComments && element instanceof PsiComment;
        }

        @Override
        public void visitComposite(CompositeElement composite) {
            if (composite instanceof LazyParseableElement) {
                LazyParseableElement lpe = (LazyParseableElement)composite;
                int lpeResult = lpe.copyTo(this.buffer, this.end);
                if (lpeResult >= 0) {
                    this.end = lpeResult;
                    return;
                }
                assert (lpe.isParsed());
            }
            super.visitComposite(composite);
        }
    }
}

