/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.text;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ex.DocumentBulkUpdateListener;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.PsiTreeChangeEventImpl;
import com.intellij.psi.impl.source.DummyHolder;
import com.intellij.psi.impl.source.DummyHolderFactory;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.text.DiffLog;
import com.intellij.psi.impl.source.tree.ASTShallowComparator;
import com.intellij.psi.impl.source.tree.ASTStructure;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.templateLanguages.ITemplateDataElementType;
import com.intellij.psi.text.BlockSupport;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IReparseableElementType;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.CharTable;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.diff.DiffTree;
import com.intellij.util.diff.DiffTreeChangeBuilder;
import com.intellij.util.diff.FlyweightCapableTreeStructure;
import com.intellij.util.diff.ShallowNodeComparator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockSupportImpl
extends BlockSupport {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.text.BlockSupportImpl");

    public BlockSupportImpl(Project project2) {
        project2.getMessageBus().connect().subscribe(DocumentBulkUpdateListener.TOPIC, (Object)new DocumentBulkUpdateListener.Adapter(){

            @Override
            public void updateStarted(@NotNull Document doc) {
                doc.putUserData(BlockSupport.DO_NOT_REPARSE_INCREMENTALLY, (Object)Boolean.TRUE);
            }
        });
    }

    @Override
    public void reparseRange(PsiFile file2, int startOffset, int endOffset, CharSequence newTextS) throws IncorrectOperationException {
        LOG.assertTrue(file2.isValid());
        PsiFileImpl psiFile = (PsiFileImpl)file2;
        Document document = psiFile.getViewProvider().getDocument();
        assert (document != null);
        document.replaceString(startOffset, endOffset, newTextS);
        PsiDocumentManager.getInstance((Project)psiFile.getProject()).commitDocument(document);
    }

    @Override
    @NotNull
    public DiffLog reparseRange(@NotNull PsiFile file2, @NotNull TextRange changedPsiRange, @NotNull CharSequence newFileText, @NotNull ProgressIndicator indicator, @NotNull CharSequence lastCommittedText) {
        PsiFileImpl fileImpl = (PsiFileImpl)file2;
        Couple<ASTNode> reparseableRoots = this.findReparseableRoots(fileImpl, changedPsiRange, newFileText);
        return reparseableRoots != null ? BlockSupportImpl.mergeTrees(fileImpl, (ASTNode)reparseableRoots.first, (ASTNode)reparseableRoots.second, indicator, lastCommittedText) : BlockSupportImpl.makeFullParse(fileImpl, newFileText, indicator, lastCommittedText);
    }

    @Nullable
    public Couple<ASTNode> findReparseableRoots(@NotNull PsiFileImpl file2, @NotNull TextRange changedPsiRange, @NotNull CharSequence newFileText) {
        Project project2 = file2.getProject();
        FileElement fileElement = file2.getTreeElement();
        CharTable charTable = fileElement.getCharTable();
        int lengthShift = newFileText.length() - fileElement.getTextLength();
        if (fileElement.getElementType() instanceof ITemplateDataElementType || BlockSupportImpl.isTooDeep((UserDataHolder)file2)) {
            return null;
        }
        LeafElement leafAtStart = fileElement.findLeafElementAt(Math.max(0, changedPsiRange.getStartOffset() - 1));
        LeafElement leafAtEnd = fileElement.findLeafElementAt(Math.min(changedPsiRange.getEndOffset(), fileElement.getTextLength() - 1));
        Language baseLanguage = file2.getViewProvider().getBaseLanguage();
        for (FileElement node = leafAtStart != null && leafAtEnd != null ? TreeUtil.findCommonParent(leafAtStart, leafAtEnd) : fileElement; node != null && !(node instanceof FileElement); node = node.getTreeParent()) {
            ASTNode chameleon;
            IElementType elementType = node.getElementType();
            if (!(elementType instanceof IReparseableElementType)) continue;
            TextRange textRange = node.getTextRange();
            IReparseableElementType reparseable = (IReparseableElementType)elementType;
            if (!baseLanguage.isKindOf(reparseable.getLanguage()) || textRange.getLength() + lengthShift <= 0) continue;
            int start = textRange.getStartOffset();
            int end = start + textRange.getLength() + lengthShift;
            if (end > newFileText.length()) {
                BlockSupportImpl.reportInconsistentLength(file2, newFileText, node, start, end);
                break;
            }
            CharSequence newTextStr = newFileText.subSequence(start, end);
            if (!reparseable.isParsable(node.getTreeParent(), newTextStr, baseLanguage, project2) || (chameleon = reparseable.createNode(newTextStr)) == null) continue;
            DummyHolder holder = DummyHolderFactory.createHolder(file2.getManager(), null, node.getPsi(), charTable);
            holder.getTreeElement().rawAddChildren((TreeElement)chameleon);
            if (holder.getTextLength() != newTextStr.length()) {
                String details = ApplicationManager.getApplication().isInternal() ? "text=" + newTextStr + "; treeText=" + holder.getText() + ";" : "";
                LOG.error("Inconsistent reparse: " + details + " type=" + elementType);
            }
            return Couple.of((Object)node, (Object)chameleon);
        }
        return null;
    }

    private static void reportInconsistentLength(PsiFile file2, CharSequence newFileText, ASTNode node, int start, int end) {
        String message = "Index out of bounds: type=" + node.getElementType() + "; file=" + file2 + "; file.class=" + file2.getClass() + "; start=" + start + "; end=" + end + "; length=" + node.getTextLength();
        String newTextBefore = newFileText.subSequence(0, start).toString();
        String oldTextBefore = file2.getText().subSequence(0, start).toString();
        if (oldTextBefore.equals(newTextBefore)) {
            message = message + "; oldTextBefore==newTextBefore";
        }
        LOG.error(message, new Attachment[]{new Attachment(file2.getName() + "_oldNodeText.txt", node.getText()), new Attachment(file2.getName() + "_oldFileText.txt", file2.getText()), new Attachment(file2.getName() + "_newFileText.txt", newFileText.toString())});
    }

    @NotNull
    private static DiffLog makeFullParse(@NotNull PsiFileImpl fileImpl, @NotNull CharSequence newFileText, @NotNull ProgressIndicator indicator, @NotNull CharSequence lastCommittedText) {
        if (fileImpl instanceof PsiCodeFragment) {
            FileElement parent = fileImpl.getTreeElement();
            FileElement holderElement = new DummyHolder(fileImpl.getManager(), null).getTreeElement();
            holderElement.rawAddChildren(fileImpl.createContentLeafElement(holderElement.getCharTable().intern(newFileText, 0, newFileText.length())));
            DiffLog diffLog = new DiffLog();
            diffLog.appendReplaceFileElement(parent, (FileElement)holderElement.getFirstChildNode());
            return diffLog;
        }
        FileViewProvider viewProvider = fileImpl.getViewProvider();
        viewProvider.getLanguages();
        FileType fileType = viewProvider.getVirtualFile().getFileType();
        String fileName = fileImpl.getName();
        LightVirtualFile lightFile = new LightVirtualFile(fileName, fileType, newFileText, viewProvider.getVirtualFile().getCharset(), fileImpl.getViewProvider().getModificationStamp());
        lightFile.setOriginalFile(viewProvider.getVirtualFile());
        FileViewProvider copy = viewProvider.createCopy((VirtualFile)lightFile);
        if (copy.isEventSystemEnabled()) {
            throw new AssertionError((Object)("Copied view provider must be non-physical for reparse to deliver correct events: " + viewProvider));
        }
        copy.getLanguages();
        SingleRootFileViewProvider.doNotCheckFileSizeLimit((VirtualFile)lightFile);
        PsiFileImpl newFile = BlockSupportImpl.getFileCopy(fileImpl, copy);
        newFile.setOriginalFile(fileImpl);
        FileElement newFileElement = (FileElement)newFile.getNode();
        FileElement oldFileElement = (FileElement)fileImpl.getNode();
        if (!lastCommittedText.toString().equals(oldFileElement.getText())) {
            throw new IncorrectOperationException(viewProvider.toString());
        }
        DiffLog diffLog = BlockSupportImpl.mergeTrees(fileImpl, oldFileElement, newFileElement, indicator, lastCommittedText);
        ((PsiManagerEx)fileImpl.getManager()).getFileManager().setViewProvider((VirtualFile)lightFile, null);
        return diffLog;
    }

    @NotNull
    public static PsiFileImpl getFileCopy(@NotNull PsiFileImpl originalFile, @NotNull FileViewProvider providerCopy) {
        FileViewProvider viewProvider = originalFile.getViewProvider();
        Language language = originalFile.getLanguage();
        PsiFile file2 = providerCopy.getPsi(language);
        if (file2 != null && !(file2 instanceof PsiFileImpl)) {
            throw new RuntimeException("View provider " + viewProvider + " refused to provide PsiFileImpl for " + language + BlockSupportImpl.details(providerCopy, viewProvider));
        }
        PsiFileImpl newFile = (PsiFileImpl)file2;
        if (newFile == null && language == PlainTextLanguage.INSTANCE && originalFile == viewProvider.getPsi(viewProvider.getBaseLanguage())) {
            newFile = (PsiFileImpl)providerCopy.getPsi(providerCopy.getBaseLanguage());
        }
        if (newFile == null) {
            throw new RuntimeException("View provider " + viewProvider + " refused to parse text with " + language + BlockSupportImpl.details(providerCopy, viewProvider));
        }
        return newFile;
    }

    private static String details(FileViewProvider providerCopy, FileViewProvider viewProvider) {
        return "; languages: " + viewProvider.getLanguages() + "; base: " + viewProvider.getBaseLanguage() + "; copy: " + providerCopy + "; copy.base: " + providerCopy.getBaseLanguage() + "; vFile: " + viewProvider.getVirtualFile() + "; copy.vFile: " + providerCopy.getVirtualFile() + "; fileType: " + viewProvider.getVirtualFile().getFileType() + "; copy.original(): " + (providerCopy.getVirtualFile() instanceof LightVirtualFile ? ((LightVirtualFile)providerCopy.getVirtualFile()).getOriginalFile() : null);
    }

    @NotNull
    private static DiffLog replaceElementWithEvents(@NotNull CompositeElement oldRoot, @NotNull CompositeElement newRoot) {
        DiffLog diffLog = new DiffLog();
        diffLog.appendReplaceElementWithEvents(oldRoot, newRoot);
        return diffLog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static DiffLog mergeTrees(@NotNull PsiFileImpl fileImpl, @NotNull ASTNode oldRoot, @NotNull ASTNode newRoot, @NotNull ProgressIndicator indicator, @NotNull CharSequence lastCommittedText) {
        if (newRoot instanceof FileElement) {
            ((FileElement)newRoot).setCharTable(fileImpl.getTreeElement().getCharTable());
        }
        try {
            newRoot.putUserData(TREE_TO_BE_REPARSED, (Object)Pair.create((Object)oldRoot, (Object)lastCommittedText));
            if (BlockSupportImpl.isReplaceWholeNode(fileImpl, newRoot)) {
                DiffLog treeChangeEvent = BlockSupportImpl.replaceElementWithEvents((CompositeElement)oldRoot, (CompositeElement)newRoot);
                fileImpl.putUserData(TREE_DEPTH_LIMIT_EXCEEDED, Boolean.TRUE);
                DiffLog diffLog = treeChangeEvent;
                return diffLog;
            }
            newRoot.getFirstChildNode();
        }
        catch (BlockSupport.ReparsedSuccessfullyException e) {
            DiffLog diffLog = e.getDiffLog();
            return diffLog;
        }
        finally {
            newRoot.putUserData(TREE_TO_BE_REPARSED, null);
        }
        ASTShallowComparator comparator2 = new ASTShallowComparator(indicator);
        ASTStructure treeStructure = BlockSupportImpl.createInterruptibleASTStructure(newRoot, indicator);
        DiffLog diffLog = new DiffLog();
        BlockSupportImpl.diffTrees(oldRoot, diffLog, comparator2, treeStructure, indicator, lastCommittedText);
        return diffLog;
    }

    public static <T> void diffTrees(@NotNull ASTNode oldRoot, @NotNull DiffTreeChangeBuilder<ASTNode, T> builder, @NotNull ShallowNodeComparator<ASTNode, T> comparator2, @NotNull FlyweightCapableTreeStructure<T> newTreeStructure, @NotNull ProgressIndicator indicator, @NotNull CharSequence lastCommittedText) {
        TreeUtil.ensureParsedRecursivelyCheckingProgress(oldRoot, indicator);
        DiffTree.diff((FlyweightCapableTreeStructure)BlockSupportImpl.createInterruptibleASTStructure(oldRoot, indicator), newTreeStructure, comparator2, builder, (CharSequence)lastCommittedText);
    }

    private static ASTStructure createInterruptibleASTStructure(@NotNull ASTNode oldRoot, final @NotNull ProgressIndicator indicator) {
        return new ASTStructure(oldRoot){

            @Override
            public int getChildren(@NotNull ASTNode astNode, @NotNull Ref<ASTNode[]> into) {
                indicator.checkCanceled();
                return super.getChildren(astNode, into);
            }
        };
    }

    private static boolean isReplaceWholeNode(@NotNull PsiFileImpl fileImpl, @NotNull ASTNode newRoot) throws BlockSupport.ReparsedSuccessfullyException {
        boolean explicitlyMarkedDeep;
        Boolean data = (Boolean)fileImpl.getUserData(DO_NOT_REPARSE_INCREMENTALLY);
        if (data != null) {
            fileImpl.putUserData(DO_NOT_REPARSE_INCREMENTALLY, null);
        }
        if ((explicitlyMarkedDeep = Boolean.TRUE.equals(data)) || BlockSupportImpl.isTooDeep((UserDataHolder)fileImpl)) {
            return true;
        }
        ASTNode childNode = newRoot.getFirstChildNode();
        boolean childTooDeep = BlockSupportImpl.isTooDeep((UserDataHolder)childNode);
        if (childTooDeep) {
            childNode.putUserData(TREE_DEPTH_LIMIT_EXCEEDED, null);
            fileImpl.putUserData(TREE_DEPTH_LIMIT_EXCEEDED, Boolean.TRUE);
        }
        return childTooDeep;
    }

    public static void sendBeforeChildrenChangeEvent(@NotNull PsiManagerImpl manager, @NotNull PsiElement scope, boolean isGenericChange) {
        if (!scope.isPhysical()) {
            manager.beforeChange(false);
            return;
        }
        PsiTreeChangeEventImpl event = new PsiTreeChangeEventImpl(manager);
        event.setParent(scope);
        event.setFile(scope.getContainingFile());
        TextRange range = scope.getTextRange();
        event.setOffset(range == null ? 0 : range.getStartOffset());
        event.setOldLength(scope.getTextLength());
        event.setGenericChange(isGenericChange);
        manager.beforeChildrenChange(event);
    }

    public static void sendAfterChildrenChangedEvent(@NotNull PsiManagerImpl manager, @NotNull PsiFile scope, int oldLength, boolean isGenericChange) {
        if (!scope.isPhysical()) {
            manager.afterChange(false);
            return;
        }
        PsiTreeChangeEventImpl event = new PsiTreeChangeEventImpl(manager);
        event.setParent((PsiElement)scope);
        event.setFile(scope);
        event.setOffset(0);
        event.setOldLength(oldLength);
        event.setGenericChange(isGenericChange);
        manager.childrenChanged(event);
    }
}

