/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.providers;

import com.intellij.codeInsight.completion.JavaClassNameCompletionContributor;
import com.intellij.codeInsight.completion.JavaLookupElementBuilder;
import com.intellij.codeInsight.completion.scope.JavaCompletionProcessor;
import com.intellij.codeInsight.daemon.QuickFixActionRegistrar;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixActionRegistrarImpl;
import com.intellij.codeInsight.daemon.quickFix.CreateClassOrPackageFix;
import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixProvider;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementManipulator;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaReference;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.ServerPageFile;
import com.intellij.psi.impl.source.resolve.ClassResolverProcessor;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.impl.source.resolve.reference.impl.GenericReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.CustomizableReferenceProvider;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReferenceProvider;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReferenceSet;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.infos.ClassCandidateInfo;
import com.intellij.psi.scope.JavaScopeProcessorEvent;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.scope.util.PsiScopesUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PackageScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.util.ClassKind;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CharArrayUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaClassReference
extends GenericReference
implements PsiJavaReference,
LocalQuickFixProvider {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReference");
    protected final int myIndex;
    private TextRange myRange;
    private final String myText;
    private final boolean myInStaticImport;
    private final JavaClassReferenceSet myJavaClassReferenceSet;

    public JavaClassReference(JavaClassReferenceSet referenceSet, TextRange range, int index, String text, boolean staticImport) {
        super(referenceSet.getProvider());
        this.myInStaticImport = staticImport;
        LOG.assertTrue(range.getEndOffset() <= referenceSet.getElement().getTextLength());
        this.myIndex = index;
        this.myRange = range;
        this.myText = text;
        this.myJavaClassReferenceSet = referenceSet;
    }

    @Override
    @Nullable
    public PsiElement getContext() {
        PsiReference contextRef = this.getContextReference();
        assert (contextRef != this) : this.getCanonicalText();
        return contextRef != null ? contextRef.resolve() : null;
    }

    @Override
    public void processVariants(final @NotNull PsiScopeProcessor processor2) {
        Map<CustomizableReferenceProvider.CustomizationKey, Object> options;
        if (processor2 instanceof JavaCompletionProcessor && ((options = this.getOptions()) != null && (JavaClassReferenceProvider.EXTEND_CLASS_NAMES.getValue(options) != null || JavaClassReferenceProvider.NOT_INTERFACE.getBooleanValue(options) || JavaClassReferenceProvider.CONCRETE.getBooleanValue(options)) || JavaClassReferenceProvider.CLASS_KIND.getValue(options) != null)) {
            ((JavaCompletionProcessor)processor2).setCompletionElements(this.getVariants());
            return;
        }
        PsiScopeProcessor processorToUse = processor2;
        if (this.myInStaticImport) {
            processor2.handleEvent((PsiScopeProcessor.Event)JavaScopeProcessorEvent.CHANGE_LEVEL, null);
        } else {
            if (this.isDefinitelyStatic()) {
                processor2.handleEvent((PsiScopeProcessor.Event)JavaScopeProcessorEvent.START_STATIC, null);
            }
            processorToUse = new PsiScopeProcessor(){

                public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
                    return !(element instanceof PsiClass) && !(element instanceof PsiPackage) || processor2.execute(element, state);
                }

                public <V> V getHint(@NotNull Key<V> hintKey) {
                    return (V)processor2.getHint(hintKey);
                }

                public void handleEvent(@NotNull PsiScopeProcessor.Event event, Object associated) {
                    processor2.handleEvent(event, associated);
                }
            };
        }
        super.processVariants(processorToUse);
    }

    private boolean isDefinitelyStatic() {
        String s = this.getElement().getText();
        return this.isStaticClassReference(s, true);
    }

    private boolean isStaticClassReference(String s, boolean strict) {
        if (this.myIndex == 0) {
            return false;
        }
        char c = s.charAt(this.getRangeInElement().getStartOffset() - 1);
        return this.myJavaClassReferenceSet.isStaticSeparator(c, strict);
    }

    @Override
    @Nullable
    public PsiReference getContextReference() {
        return this.myIndex > 0 ? this.myJavaClassReferenceSet.getReference(this.myIndex - 1) : null;
    }

    private boolean canReferencePackage() {
        return this.myJavaClassReferenceSet.canReferencePackage(this.myIndex);
    }

    public PsiElement getElement() {
        return this.myJavaClassReferenceSet.getElement();
    }

    @Override
    public boolean isReferenceTo(PsiElement element) {
        return (element instanceof PsiClass || element instanceof PsiPackage) && super.isReferenceTo(element);
    }

    public TextRange getRangeInElement() {
        return this.myRange;
    }

    @NotNull
    public String getCanonicalText() {
        return this.myText;
    }

    @Override
    public boolean isSoft() {
        return this.myJavaClassReferenceSet.isSoft();
    }

    @Override
    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        ElementManipulator<PsiElement> manipulator = JavaClassReference.getManipulator(this.getElement());
        PsiElement element = manipulator.handleContentChange(this.getElement(), this.getRangeInElement(), newElementName);
        this.myRange = new TextRange(this.getRangeInElement().getStartOffset(), this.getRangeInElement().getStartOffset() + newElementName.length());
        return element;
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        String newName;
        if (this.isReferenceTo(element)) {
            return this.getElement();
        }
        if (element instanceof PsiClass) {
            PsiClass psiClass = (PsiClass)element;
            boolean jvmFormat = Boolean.TRUE.equals(JavaClassReferenceProvider.JVM_FORMAT.getValue(this.getOptions()));
            newName = jvmFormat ? ClassUtil.getJVMClassName((PsiClass)psiClass) : psiClass.getQualifiedName();
        } else if (element instanceof PsiPackage) {
            PsiPackage psiPackage = (PsiPackage)element;
            newName = psiPackage.getQualifiedName();
        } else {
            throw new IncorrectOperationException("Cannot bind to " + element);
        }
        assert (newName != null);
        int end = this.getRangeInElement().getEndOffset();
        String text = this.getElement().getText();
        int lt = text.indexOf(60, this.getRangeInElement().getStartOffset());
        if (lt >= 0 && lt < end) {
            end = CharArrayUtil.shiftBackward((CharSequence)text, (int)(lt - 1), (String)"\n\t ") + 1;
        }
        TextRange range = new TextRange(this.myJavaClassReferenceSet.getReference(0).getRangeInElement().getStartOffset(), end);
        ElementManipulator<PsiElement> manipulator = JavaClassReference.getManipulator(this.getElement());
        PsiElement finalElement = manipulator.handleContentChange(this.getElement(), range, newName);
        this.myJavaClassReferenceSet.reparse(finalElement, TextRange.from((int)range.getStartOffset(), (int)newName.length()));
        return finalElement;
    }

    @Override
    public PsiElement resolveInner() {
        return this.advancedResolve(true).getElement();
    }

    @NotNull
    public Object[] getVariants() {
        PsiElement context = this.getCompletionContext();
        if (context instanceof PsiPackage) {
            return this.processPackage((PsiPackage)context);
        }
        if (context instanceof PsiClass) {
            PsiClass aClass = (PsiClass)context;
            if (this.myInStaticImport) {
                return ArrayUtil.mergeArrays((Object[])aClass.getInnerClasses(), (Object[])aClass.getFields(), (ArrayFactory)ArrayUtil.OBJECT_ARRAY_FACTORY);
            }
            if (this.isDefinitelyStatic()) {
                PsiClass[] psiClasses = aClass.getInnerClasses();
                ArrayList<PsiClass> staticClasses = new ArrayList<PsiClass>(psiClasses.length);
                for (PsiClass c : psiClasses) {
                    if (!c.hasModifierProperty("static")) continue;
                    staticClasses.add(c);
                }
                return staticClasses.isEmpty() ? PsiClass.EMPTY_ARRAY : staticClasses.toArray(new PsiClass[staticClasses.size()]);
            }
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    @Nullable
    public PsiElement getCompletionContext() {
        PsiElement context = this.getContext();
        return context == null ? JavaPsiFacade.getInstance((Project)this.getElement().getProject()).findPackage("") : context;
    }

    public String[] getExtendClassNames() {
        return JavaClassReferenceProvider.EXTEND_CLASS_NAMES.getValue(this.getOptions());
    }

    @NotNull
    private LookupElement[] processPackage(@NotNull PsiPackage aPackage) {
        ArrayList list = ContainerUtil.newArrayList();
        int startOffset = StringUtil.isEmpty((String)aPackage.getName()) ? 0 : aPackage.getQualifiedName().length() + 1;
        GlobalSearchScope scope = this.getScope(this.getJavaContextFile());
        for (PsiPackage subPackage : aPackage.getSubPackages(scope)) {
            String shortName = subPackage.getQualifiedName().substring(startOffset);
            if (!PsiNameHelper.getInstance((Project)subPackage.getProject()).isIdentifier(shortName)) continue;
            list.add(LookupElementBuilder.create((PsiNamedElement)subPackage).withIcon(subPackage.getIcon(1)));
        }
        List classes = ContainerUtil.filter((Object[])aPackage.getClasses(scope), (Condition)new Condition<PsiClass>(){

            public boolean value(PsiClass psiClass) {
                return StringUtil.isNotEmpty((String)psiClass.getName());
            }
        });
        Map<CustomizableReferenceProvider.CustomizationKey, Object> options = this.getOptions();
        if (options != null) {
            boolean instantiatable = JavaClassReferenceProvider.INSTANTIATABLE.getBooleanValue(options);
            boolean concrete = JavaClassReferenceProvider.CONCRETE.getBooleanValue(options);
            boolean notInterface = JavaClassReferenceProvider.NOT_INTERFACE.getBooleanValue(options);
            boolean notEnum = JavaClassReferenceProvider.NOT_ENUM.getBooleanValue(options);
            ClassKind classKind = this.getClassKind();
            for (PsiClass clazz : classes) {
                if (!JavaClassReference.isClassAccepted(clazz, classKind, instantiatable, concrete, notInterface, notEnum)) continue;
                list.add(JavaClassNameCompletionContributor.createClassLookupItem(clazz, false));
            }
        } else {
            for (PsiClass clazz : classes) {
                list.add(JavaClassNameCompletionContributor.createClassLookupItem(clazz, false));
            }
        }
        return list.toArray(new LookupElement[list.size()]);
    }

    @Nullable
    public ClassKind getClassKind() {
        return JavaClassReferenceProvider.CLASS_KIND.getValue(this.getOptions());
    }

    private static boolean isClassAccepted(PsiClass clazz, @Nullable ClassKind classKind, boolean instantiatable, boolean concrete, boolean notInterface, boolean notEnum) {
        if (classKind == ClassKind.ANNOTATION) {
            return clazz.isAnnotationType();
        }
        if (classKind == ClassKind.ENUM) {
            return clazz.isEnum();
        }
        if (instantiatable) {
            if (PsiUtil.isInstantiatable((PsiClass)clazz)) {
                return true;
            }
        } else if (concrete) {
            if (!clazz.hasModifierProperty("abstract") && !clazz.isInterface()) {
                return true;
            }
        } else if (notInterface) {
            if (!clazz.isInterface()) {
                return true;
            }
        } else if (notEnum) {
            if (!clazz.isEnum()) {
                return true;
            }
        } else {
            return true;
        }
        return false;
    }

    @NotNull
    public JavaResolveResult advancedResolve(boolean incompleteCode) {
        PsiFile file2 = this.getJavaContextFile();
        ResolveCache resolveCache = ResolveCache.getInstance(file2.getProject());
        return (JavaResolveResult)resolveCache.resolveWithCaching(this, MyResolver.INSTANCE, false, false, file2)[0];
    }

    private PsiFile getJavaContextFile() {
        return this.myJavaClassReferenceSet.getProvider().getContextFile(this.getElement());
    }

    @NotNull
    private JavaResolveResult doAdvancedResolve(@NotNull PsiFile containingFile) {
        JavaResolveResult resolveResult;
        String defaultPackage;
        int endOffset;
        PsiElement psiElement = this.getElement();
        if (!psiElement.isValid()) {
            return JavaResolveResult.EMPTY;
        }
        String elementText = psiElement.getText();
        PsiElement context = this.getContext();
        if (context instanceof PsiClass) {
            if (this.isStaticClassReference(elementText, false)) {
                PsiClass psiClass = ((PsiClass)context).findInnerClassByName(this.getCanonicalText(), false);
                if (psiClass != null) {
                    return new ClassCandidateInfo((PsiElement)psiClass, PsiSubstitutor.EMPTY, false, psiElement);
                }
                PsiElement member = JavaClassReference.doResolveMember((PsiClass)context, this.myText);
                return member == null ? JavaResolveResult.EMPTY : new CandidateInfo(member, PsiSubstitutor.EMPTY, false, false, psiElement);
            }
            if (!this.myInStaticImport && this.myJavaClassReferenceSet.isAllowDollarInNames()) {
                return JavaResolveResult.EMPTY;
            }
        }
        LOG.assertTrue((endOffset = this.getRangeInElement().getEndOffset()) <= elementText.length(), (Object)elementText);
        int startOffset = this.myJavaClassReferenceSet.getReference(0).getRangeInElement().getStartOffset();
        String qName = elementText.substring(startOffset, endOffset);
        if (!qName.contains(".") && StringUtil.isNotEmpty((String)(defaultPackage = JavaClassReferenceProvider.DEFAULT_PACKAGE.getValue(this.getOptions()))) && (resolveResult = this.advancedResolveInner(psiElement, defaultPackage + "." + qName, containingFile)) != JavaResolveResult.EMPTY) {
            return resolveResult;
        }
        return this.advancedResolveInner(psiElement, qName, containingFile);
    }

    private JavaResolveResult advancedResolveInner(@NotNull PsiElement psiElement, @NotNull String qName, @NotNull PsiFile containingFile) {
        PsiPackage resolveResult;
        PsiManager manager = containingFile.getManager();
        GlobalSearchScope scope = this.getScope(containingFile);
        if (this.myIndex == this.myJavaClassReferenceSet.getReferences().length - 1) {
            PsiClass aClass = JavaPsiFacade.getInstance((Project)manager.getProject()).findClass(qName, scope);
            if (aClass != null) {
                return new ClassCandidateInfo((PsiElement)aClass, PsiSubstitutor.EMPTY, false, psiElement);
            }
            if (!JavaClassReferenceProvider.ADVANCED_RESOLVE.getBooleanValue(this.getOptions())) {
                return JavaResolveResult.EMPTY;
            }
        }
        if ((resolveResult = JavaPsiFacade.getInstance((Project)manager.getProject()).findPackage(qName)) == null) {
            resolveResult = JavaPsiFacade.getInstance((Project)manager.getProject()).findClass(qName, scope);
        }
        if (this.myInStaticImport && resolveResult == null) {
            resolveResult = JavaClassReference.resolveMember(qName, manager, this.getElement().getResolveScope());
        }
        if (resolveResult == null && containingFile instanceof PsiJavaFile) {
            if (containingFile instanceof ServerPageFile && (containingFile = containingFile.getViewProvider().getPsi((Language)JavaLanguage.INSTANCE)) == null) {
                return JavaResolveResult.EMPTY;
            }
            ClassResolverProcessor processor2 = new ClassResolverProcessor(this.getCanonicalText(), psiElement, containingFile);
            PsiClass contextClass = this.myJavaClassReferenceSet.getProvider().getContextClass(psiElement);
            if (contextClass != null) {
                PsiScopesUtil.treeWalkUp(processor2, (PsiElement)contextClass, null);
            } else {
                containingFile.processDeclarations((PsiScopeProcessor)processor2, ResolveState.initial(), null, psiElement);
            }
            if (processor2.getResult().length == 1) {
                JavaResolveResult javaResolveResult = processor2.getResult()[0];
                if (javaResolveResult != JavaResolveResult.EMPTY && this.getOptions() != null) {
                    String qualifiedName;
                    Boolean value = JavaClassReferenceProvider.RESOLVE_QUALIFIED_CLASS_NAME.getValue(this.getOptions());
                    PsiClass psiClass = (PsiClass)javaResolveResult.getElement();
                    if (value != null && value.booleanValue() && psiClass != null && !qName.equals(qualifiedName = psiClass.getQualifiedName())) {
                        return JavaResolveResult.EMPTY;
                    }
                }
                return javaResolveResult;
            }
        }
        return resolveResult != null ? new CandidateInfo((PsiElement)resolveResult, PsiSubstitutor.EMPTY, false, false, psiElement) : JavaResolveResult.EMPTY;
    }

    private GlobalSearchScope getScope(@NotNull PsiFile containingFile) {
        Project project2 = containingFile.getProject();
        GlobalSearchScope scope = this.myJavaClassReferenceSet.getProvider().getScope(project2);
        if (scope == null) {
            Module module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)containingFile);
            return module2 == null ? GlobalSearchScope.allScope((Project)project2) : module2.getModuleWithDependenciesAndLibrariesScope(true);
        }
        return scope;
    }

    @Nullable
    private Map<CustomizableReferenceProvider.CustomizationKey, Object> getOptions() {
        return this.myJavaClassReferenceSet.getOptions();
    }

    @NotNull
    public JavaResolveResult[] multiResolve(boolean incompleteCode) {
        JavaResolveResult javaResolveResult = this.advancedResolve(incompleteCode);
        if (javaResolveResult.getElement() == null) {
            return JavaResolveResult.EMPTY_ARRAY;
        }
        return new JavaResolveResult[]{javaResolveResult};
    }

    @Nullable
    private List<? extends LocalQuickFix> registerFixes() {
        ClassKind kind;
        List list = QuickFixFactory.getInstance().registerOrderEntryFixes((QuickFixActionRegistrar)new QuickFixActionRegistrarImpl(null), (PsiReference)this);
        String[] extendClasses = this.getExtendClassNames();
        String extendClass = extendClasses != null && extendClasses.length > 0 ? extendClasses[0] : null;
        JavaClassReference[] references = this.getJavaClassReferenceSet().getAllReferences();
        PsiPackage contextPackage = null;
        for (int i = this.myIndex; i >= 0; --i) {
            PsiElement context = references[i].getContext();
            if (context == null) continue;
            if (!(context instanceof PsiPackage)) break;
            contextPackage = (PsiPackage)context;
            break;
        }
        boolean createJavaClass = !this.canReferencePackage();
        ClassKind classKind = kind = createJavaClass ? this.getClassKind() : null;
        if (createJavaClass && kind == null) {
            kind = ClassKind.CLASS;
        }
        String templateName = JavaClassReferenceProvider.CLASS_TEMPLATE.getValue(this.getOptions());
        TextRange range = new TextRange(references[0].getRangeInElement().getStartOffset(), this.getRangeInElement().getEndOffset());
        String qualifiedName = range.substring(this.getElement().getText());
        CreateClassOrPackageFix action = CreateClassOrPackageFix.createFix(qualifiedName, this.getScope(this.getJavaContextFile()), this.getElement(), contextPackage, kind, extendClass, templateName);
        if (action != null) {
            if (list == null) {
                return Collections.singletonList(action);
            }
            ArrayList<CreateClassOrPackageFix> fixes = new ArrayList<CreateClassOrPackageFix>(list.size() + 1);
            fixes.addAll(list);
            fixes.add(action);
            return fixes;
        }
        return list;
    }

    public void processSubclassVariants(@NotNull PsiPackage context, @NotNull String[] extendClasses, Consumer<LookupElement> result) {
        GlobalSearchScope packageScope = PackageScope.packageScope((PsiPackage)context, (boolean)true);
        GlobalSearchScope scope = this.myJavaClassReferenceSet.getProvider().getScope(this.getElement().getProject());
        if (scope != null) {
            packageScope = packageScope.intersectWith(scope);
        }
        GlobalSearchScope allScope = ProjectScope.getAllScope((Project)context.getProject());
        boolean instantiatable = JavaClassReferenceProvider.INSTANTIATABLE.getBooleanValue(this.getOptions());
        boolean notInterface = JavaClassReferenceProvider.NOT_INTERFACE.getBooleanValue(this.getOptions());
        boolean notEnum = JavaClassReferenceProvider.NOT_ENUM.getBooleanValue(this.getOptions());
        boolean concrete = JavaClassReferenceProvider.CONCRETE.getBooleanValue(this.getOptions());
        ClassKind classKind = this.getClassKind();
        for (String extendClassName : extendClasses) {
            PsiClass extendClass = JavaPsiFacade.getInstance((Project)context.getProject()).findClass(extendClassName, allScope);
            if (extendClass == null) continue;
            if (packageScope.contains(extendClass.getContainingFile().getVirtualFile()) && JavaClassReference.isClassAccepted(extendClass, classKind, instantiatable, concrete, notInterface, notEnum)) {
                result.consume((Object)JavaClassReference.createSubclassLookupValue(extendClass, extendClassName));
            }
            for (PsiClass clazz : ClassInheritorsSearch.search((PsiClass)extendClass, (SearchScope)packageScope, (boolean)true)) {
                String qname = clazz.getQualifiedName();
                if (qname == null || !JavaClassReference.isClassAccepted(clazz, classKind, instantiatable, concrete, notInterface, notEnum)) continue;
                result.consume((Object)JavaClassReference.createSubclassLookupValue(clazz, qname));
            }
        }
    }

    @NotNull
    private static LookupElementBuilder createSubclassLookupValue(@NotNull PsiClass clazz, @NotNull String qname) {
        return JavaLookupElementBuilder.forClass(clazz, qname, true).withPresentableText(StringUtil.getShortName((String)qname));
    }

    public LocalQuickFix[] getQuickFixes() {
        List<? extends LocalQuickFix> list = this.registerFixes();
        return list == null ? LocalQuickFix.EMPTY_ARRAY : list.toArray(new LocalQuickFix[list.size()]);
    }

    @Nullable
    public static PsiElement resolveMember(String fqn, PsiManager manager, GlobalSearchScope resolveScope) {
        PsiClass aClass = JavaPsiFacade.getInstance((Project)manager.getProject()).findClass(fqn, resolveScope);
        if (aClass != null) {
            return aClass;
        }
        int i = fqn.lastIndexOf(46);
        if (i == -1) {
            return null;
        }
        String memberName = fqn.substring(i + 1);
        fqn = fqn.substring(0, i);
        aClass = JavaPsiFacade.getInstance((Project)manager.getProject()).findClass(fqn, resolveScope);
        if (aClass == null) {
            return null;
        }
        return JavaClassReference.doResolveMember(aClass, memberName);
    }

    @Nullable
    private static PsiElement doResolveMember(PsiClass aClass, String memberName) {
        PsiField member = aClass.findFieldByName(memberName, true);
        if (member != null) {
            return member;
        }
        PsiMethod[] methods = aClass.findMethodsByName(memberName, true);
        return methods.length == 0 ? null : methods[0];
    }

    public JavaClassReferenceSet getJavaClassReferenceSet() {
        return this.myJavaClassReferenceSet;
    }

    @NotNull
    public String getUnresolvedMessagePattern() {
        return this.myJavaClassReferenceSet.getUnresolvedMessagePattern(this.myIndex);
    }

    private static class MyResolver
    implements ResolveCache.PolyVariantContextResolver<JavaClassReference> {
        private static final MyResolver INSTANCE = new MyResolver();

        private MyResolver() {
        }

        @Override
        @NotNull
        public ResolveResult[] resolve(@NotNull JavaClassReference ref, @NotNull PsiFile containingFile, boolean incompleteCode) {
            return new JavaResolveResult[]{ref.doAdvancedResolve(containingFile)};
        }
    }
}

