/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.providers;

import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.BasicAttributeValueReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileBasedUserDataCache;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.ImplicitIdRefProvider;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlComment;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.xml.util.XmlDeclareIdInCommentAction;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IdRefReference
extends BasicAttributeValueReference {
    private final boolean myIdAttrsOnly;
    private static final FileBasedUserDataCache<List<PsiElement>> ourCachedIdsCache = new FileBasedUserDataCache<List<PsiElement>>(){
        private final Key<CachedValue<List<PsiElement>>> ourCachedIdsValueKey = Key.create((String)"my.ids.cached.value");

        @Override
        protected List<PsiElement> doCompute(PsiFile file2) {
            final ArrayList<PsiElement> result = new ArrayList<PsiElement>();
            file2.accept((PsiElementVisitor)new XmlRecursiveElementVisitor(true){

                public void visitXmlTag(XmlTag tag) {
                    if (IdRefReference.isAcceptableTagType(tag)) {
                        result.add(tag);
                    }
                    super.visitXmlTag(tag);
                }

                public void visitComment(PsiComment comment) {
                    if (IdRefReference.isDeclarationComment(comment)) {
                        result.add(comment);
                    }
                    super.visitComment(comment);
                }

                public void visitXmlComment(XmlComment comment) {
                    if (IdRefReference.isDeclarationComment((PsiComment)comment)) {
                        result.add(comment);
                    }
                    super.visitComment((PsiComment)comment);
                }
            });
            return result;
        }

        @Override
        protected Key<CachedValue<List<PsiElement>>> getKey() {
            return this.ourCachedIdsValueKey;
        }
    };

    public IdRefReference(PsiElement element, int offset, boolean idAttrsOnly) {
        super(element, offset);
        this.myIdAttrsOnly = idAttrsOnly;
    }

    public IdRefReference(PsiElement element) {
        super(element);
        this.myIdAttrsOnly = false;
    }

    @Nullable
    protected PsiElement getIdValueElement(PsiElement element) {
        if (element instanceof XmlTag) {
            XmlTag tag = (XmlTag)element;
            XmlAttribute attribute = tag.getAttribute("id", null);
            if (!this.myIdAttrsOnly) {
                if (attribute == null) {
                    attribute = tag.getAttribute("name", null);
                }
                if (attribute == null) {
                    attribute = tag.getAttribute("styleId", null);
                }
            }
            return attribute != null ? attribute.getValueElement() : IdRefReference.getImplicitIdRefValueElement(tag);
        }
        return element;
    }

    @Nullable
    protected String getIdValue(PsiElement element) {
        if (element instanceof XmlTag) {
            XmlTag tag = (XmlTag)element;
            String s = tag.getAttributeValue("id");
            if (!this.myIdAttrsOnly) {
                if (s == null) {
                    s = tag.getAttributeValue("name");
                }
                if (s == null) {
                    s = tag.getAttributeValue("styleId");
                }
            }
            return s != null ? s : IdRefReference.getImplicitIdRefValue(tag);
        }
        if (element instanceof PsiComment) {
            return IdRefReference.getImplicitIdValue((PsiComment)element);
        }
        return null;
    }

    @Nullable
    public static XmlAttribute getImplicitIdRefAttr(@NotNull XmlTag tag) {
        for (ImplicitIdRefProvider idRefProvider : (ImplicitIdRefProvider[])Extensions.getExtensions(ImplicitIdRefProvider.EXTENSION_POINT_NAME)) {
            XmlAttribute value = idRefProvider.getIdRefAttribute(tag);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    @Nullable
    public static XmlAttributeValue getImplicitIdRefValueElement(@NotNull XmlTag tag) {
        for (ImplicitIdRefProvider idRefProvider : (ImplicitIdRefProvider[])Extensions.getExtensions(ImplicitIdRefProvider.EXTENSION_POINT_NAME)) {
            XmlAttribute value = idRefProvider.getIdRefAttribute(tag);
            if (value == null) continue;
            return value.getValueElement();
        }
        return null;
    }

    @Nullable
    public static String getImplicitIdRefValue(@NotNull XmlTag tag) {
        XmlAttributeValue attribute = IdRefReference.getImplicitIdRefValueElement(tag);
        return attribute != null ? attribute.getValue() : null;
    }

    protected static boolean isAcceptableTagType(XmlTag subTag) {
        return subTag.getAttributeValue("id") != null || subTag.getAttributeValue("for") != null || IdRefReference.getImplicitIdRefValue(subTag) != null || subTag.getAttributeValue("name") != null && !subTag.getName().contains(".directive");
    }

    private static boolean isDeclarationComment(@NotNull PsiComment comment) {
        return comment.getText().contains("@declare id=");
    }

    @Nullable
    private static String getImplicitIdValue(@NotNull PsiComment comment) {
        return XmlDeclareIdInCommentAction.getImplicitlyDeclaredId(comment);
    }

    private void process(PsiElementProcessor<PsiElement> processor2) {
        PsiFile psiFile = this.getElement().getContainingFile();
        IdRefReference.process(processor2, psiFile);
    }

    public static void process(PsiElementProcessor<PsiElement> processor2, PsiFile file2) {
        for (PsiElement e : ourCachedIdsCache.compute(file2)) {
            if (processor2.execute(e)) continue;
            return;
        }
    }

    @Nullable
    public PsiElement resolve() {
        final PsiElement[] result = new PsiElement[1];
        this.process(new PsiElementProcessor<PsiElement>(){
            final String canonicalText;
            {
                this.canonicalText = IdRefReference.this.getCanonicalText();
            }

            public boolean execute(@NotNull PsiElement element) {
                String idValue = IdRefReference.this.getIdValue(element);
                if (idValue != null && idValue.equals(this.canonicalText)) {
                    result[0] = IdRefReference.this.getIdValueElement(element);
                    return false;
                }
                return true;
            }
        });
        return result[0];
    }

    @NotNull
    public Object[] getVariants() {
        final LinkedList result = new LinkedList();
        this.process(new PsiElementProcessor<PsiElement>(){

            public boolean execute(@NotNull PsiElement element) {
                String value = IdRefReference.this.getIdValue(element);
                if (value != null) {
                    result.add(value);
                }
                return true;
            }
        });
        return ArrayUtil.toObjectArray(result);
    }

    public boolean isSoft() {
        return false;
    }
}

