/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.providers;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.PackagePrefixFileSystemItemImpl;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FilePathReferenceProvider
extends PsiReferenceProvider {
    private final boolean myEndingSlashNotAllowed;

    public FilePathReferenceProvider() {
        this(true);
    }

    public FilePathReferenceProvider(boolean endingSlashNotAllowed) {
        this.myEndingSlashNotAllowed = endingSlashNotAllowed;
    }

    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, String text, int offset, boolean soft) {
        return this.getReferencesByElement(element, text, offset, soft, Module.EMPTY_ARRAY);
    }

    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, String text, int offset, final boolean soft, final Module ... forModules) {
        return new FileReferenceSet(text, element, offset, this, true, this.myEndingSlashNotAllowed){

            @Override
            protected boolean isSoft() {
                return soft;
            }

            @Override
            public boolean isAbsolutePathReference() {
                return true;
            }

            @Override
            public boolean couldBeConvertedTo(boolean relative) {
                return !relative;
            }

            @Override
            public boolean absoluteUrlNeedsStartSlash() {
                String s = this.getPathString();
                return s != null && !s.isEmpty() && s.charAt(0) == '/';
            }

            @Override
            @NotNull
            public Collection<PsiFileSystemItem> computeDefaultContexts() {
                if (forModules.length > 0) {
                    LinkedHashSet rootsForModules = ContainerUtil.newLinkedHashSet();
                    for (Module forModule : forModules) {
                        rootsForModules.addAll(FilePathReferenceProvider.getRoots(forModule, true));
                    }
                    return rootsForModules;
                }
                return FilePathReferenceProvider.getRoots(ModuleUtilCore.findModuleForPsiElement((PsiElement)this.getElement()), true);
            }

            @Override
            public FileReference createFileReference(TextRange range, int index, String text) {
                return FilePathReferenceProvider.this.createFileReference(this, range, index, text);
            }

            @Override
            protected Condition<PsiFileSystemItem> getReferenceCompletionFilter() {
                return new Condition<PsiFileSystemItem>(){

                    public boolean value(PsiFileSystemItem element) {
                        return FilePathReferenceProvider.this.isPsiElementAccepted((PsiElement)element);
                    }
                };
            }
        }.getAllReferences();
    }

    public boolean acceptsTarget(@NotNull PsiElement target) {
        return target instanceof PsiFileSystemItem;
    }

    protected boolean isPsiElementAccepted(PsiElement element) {
        return !(element instanceof PsiJavaFile) || !(element instanceof PsiCompiledElement);
    }

    protected FileReference createFileReference(FileReferenceSet referenceSet, TextRange range, int index, String text) {
        return new FileReference(referenceSet, range, index, text);
    }

    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        Object value;
        String text = null;
        if (element instanceof PsiLiteralExpression && (value = ((PsiLiteralExpression)element).getValue()) instanceof String) {
            text = (String)value;
        }
        if (text == null) {
            return PsiReference.EMPTY_ARRAY;
        }
        return this.getReferencesByElement(element, text, 1, true);
    }

    @NotNull
    public static Collection<PsiFileSystemItem> getRoots(@Nullable Module thisModule, boolean includingClasses) {
        PsiDirectory directory;
        if (thisModule == null) {
            return Collections.emptyList();
        }
        ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)thisModule);
        LinkedHashSet result = ContainerUtil.newLinkedHashSet();
        PsiManager psiManager = PsiManager.getInstance((Project)thisModule.getProject());
        if (includingClasses) {
            VirtualFile[] libraryUrls;
            for (VirtualFile file2 : libraryUrls = moduleRootManager.orderEntries().getAllLibrariesAndSdkClassesRoots()) {
                directory = psiManager.findDirectory(file2);
                if (directory == null) continue;
                result.add(directory);
            }
        }
        VirtualFile[] sourceRoots = moduleRootManager.orderEntries().recursively().withoutSdk().withoutLibraries().sources().usingCache().getRoots();
        for (VirtualFile root : sourceRoots) {
            directory = psiManager.findDirectory(root);
            if (directory == null) continue;
            PsiPackage aPackage = JavaDirectoryService.getInstance().getPackage(directory);
            if (aPackage != null && aPackage.getName() != null) {
                result.add(PackagePrefixFileSystemItemImpl.create(directory));
                continue;
            }
            result.add(directory);
        }
        return result;
    }
}

