/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.manipulators;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.AbstractElementManipulator;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class StringLiteralManipulator
extends AbstractElementManipulator<PsiLiteralExpression> {
    public PsiLiteralExpression handleContentChange(@NotNull PsiLiteralExpression expr, @NotNull TextRange range, String newContent) throws IncorrectOperationException {
        String oldText = expr.getText();
        if (oldText.startsWith("\"")) {
            newContent = StringUtil.escapeStringCharacters((String)newContent);
        } else if (oldText.startsWith("'") && newContent.length() <= 1) {
            newContent = newContent.length() == 1 && newContent.charAt(0) == '\'' ? "\\'" : newContent;
        } else {
            throw new IncorrectOperationException("cannot handle content change for: " + oldText + ", expr: " + expr);
        }
        String newText = oldText.substring(0, range.getStartOffset()) + newContent + oldText.substring(range.getEndOffset());
        PsiExpression newExpr = JavaPsiFacade.getInstance((Project)expr.getProject()).getElementFactory().createExpressionFromText(newText, null);
        return (PsiLiteralExpression)expr.replace((PsiElement)newExpr);
    }

    @NotNull
    public TextRange getRangeInElement(@NotNull PsiLiteralExpression element) {
        return StringLiteralManipulator.getValueRange(element);
    }

    @NotNull
    public static TextRange getValueRange(@NotNull PsiLiteralExpression element) {
        Object value = element.getValue();
        if (!(value instanceof String) && !(value instanceof Character)) {
            return TextRange.from((int)0, (int)element.getTextLength());
        }
        return new TextRange(1, Math.max(1, element.getTextLength() - 1));
    }
}

