/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageExtension;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.patterns.ElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceProviderBean;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.PsiReferenceService;
import com.intellij.psi.ReferenceRange;
import com.intellij.psi.impl.source.resolve.reference.ProviderBinding;
import com.intellij.psi.impl.source.resolve.reference.PsiReferenceRegistrarImpl;
import com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistry;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class ReferenceProvidersRegistryImpl
extends ReferenceProvidersRegistry {
    private static final LanguageExtension<PsiReferenceContributor> CONTRIBUTOR_EXTENSION = new LanguageExtension(PsiReferenceContributor.EP_NAME.getName());
    private static final LanguageExtension<PsiReferenceProviderBean> REFERENCE_PROVIDER_EXTENSION = new LanguageExtension(PsiReferenceProviderBean.EP_NAME.getName());
    private static final Comparator<ProviderBinding.ProviderInfo<ProcessingContext>> PRIORITY_COMPARATOR = new Comparator<ProviderBinding.ProviderInfo<ProcessingContext>>(){

        @Override
        public int compare(ProviderBinding.ProviderInfo<ProcessingContext> o1, ProviderBinding.ProviderInfo<ProcessingContext> o2) {
            return Comparing.compare((double)o2.priority, (double)o1.priority);
        }
    };
    private final Map<Language, PsiReferenceRegistrarImpl> myRegistrars = ContainerUtil.newConcurrentMap();

    @NotNull
    private static PsiReferenceRegistrarImpl createRegistrar(Language language) {
        PsiReferenceRegistrarImpl registrar = new PsiReferenceRegistrarImpl(language);
        for (PsiReferenceContributor contributor : CONTRIBUTOR_EXTENSION.allForLanguage(language)) {
            contributor.registerReferenceProviders((PsiReferenceRegistrar)registrar);
        }
        List referenceProviderBeans = REFERENCE_PROVIDER_EXTENSION.allForLanguage(language);
        for (final PsiReferenceProviderBean providerBean : referenceProviderBeans) {
            ElementPattern pattern = providerBean.createElementPattern();
            if (pattern == null) continue;
            registrar.registerReferenceProvider(pattern, new PsiReferenceProvider(){
                PsiReferenceProvider myProvider;

                @NotNull
                public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
                    if (this.myProvider == null) {
                        this.myProvider = providerBean.instantiate();
                        if (this.myProvider == null) {
                            this.myProvider = ReferenceProvidersRegistry.NULL_REFERENCE_PROVIDER;
                        }
                    }
                    return this.myProvider.getReferencesByElement(element, context);
                }
            });
        }
        registrar.markInitialized();
        return registrar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public PsiReferenceRegistrarImpl getRegistrar(@NotNull Language language) {
        PsiReferenceRegistrarImpl registrar = this.myRegistrars.get(language);
        if (registrar == null) {
            ReferenceProvidersRegistryImpl referenceProvidersRegistryImpl = this;
            synchronized (referenceProvidersRegistryImpl) {
                registrar = this.myRegistrars.get(language);
                if (registrar == null) {
                    registrar = ReferenceProvidersRegistryImpl.createRegistrar(language);
                    this.myRegistrars.put(language, registrar);
                }
            }
        }
        return registrar;
    }

    @Override
    @NotNull
    protected PsiReference[] doGetReferencesFromProviders(@NotNull PsiElement context, @NotNull PsiReferenceService.Hints hints) {
        List<ProviderBinding.ProviderInfo<ProcessingContext>> providers = this.getRegistrar(context.getLanguage()).getPairsByElement(context, hints);
        if (providers.isEmpty()) {
            return PsiReference.EMPTY_ARRAY;
        }
        if (providers.size() == 1) {
            return providers.get((int)0).provider.getReferencesByElement(context, (ProcessingContext)providers.get((int)0).processingContext);
        }
        ContainerUtil.sort(providers, PRIORITY_COMPARATOR);
        ArrayList<PsiReference> result = new ArrayList<PsiReference>();
        double maxPriority = providers.get((int)0).priority;
        block2: for (ProviderBinding.ProviderInfo<ProcessingContext> trinity : providers) {
            PsiReference[] refs;
            try {
                refs = trinity.provider.getReferencesByElement(context, (ProcessingContext)trinity.processingContext);
            }
            catch (IndexNotReadyException ex) {
                continue;
            }
            if (trinity.priority != maxPriority) {
                for (PsiReference ref : refs) {
                    for (PsiReference reference : result) {
                        if (ref == null || !ReferenceRange.containsRangeInElement((PsiReference)reference, (TextRange)ref.getRangeInElement())) continue;
                        continue block2;
                    }
                }
            }
            for (PsiReference ref : refs) {
                if (ref == null) continue;
                result.add(ref);
            }
        }
        return result.isEmpty() ? PsiReference.EMPTY_ARRAY : (PsiReference[])ContainerUtil.toArray(result, (Object[])new PsiReference[result.size()]);
    }
}

