/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference;

import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.patterns.CaseInsensitiveValuePatternCondition;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiNamePatternCondition;
import com.intellij.patterns.ValuePatternCondition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.PsiReferenceService;
import com.intellij.psi.impl.source.resolve.reference.NamedObjectProviderBinding;
import com.intellij.psi.impl.source.resolve.reference.ProviderBinding;
import com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistry;
import com.intellij.psi.impl.source.resolve.reference.SimpleProviderBinding;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiReferenceRegistrarImpl
extends PsiReferenceRegistrar {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.resolve.reference.PsiReferenceRegistrarImpl");
    private final Map<Class<?>, SimpleProviderBinding> myBindingsMap = ContainerUtil.newTroveMap();
    private final Map<Class<?>, NamedObjectProviderBinding> myNamedBindingsMap = ContainerUtil.newTroveMap();
    private final ConcurrentFactoryMap<Class, ProviderBinding[]> myBindingCache;
    private boolean myInitialized;

    public PsiReferenceRegistrarImpl(final Language language) {
        this.myBindingCache = new ConcurrentFactoryMap<Class, ProviderBinding[]>(){

            @Nullable
            protected ProviderBinding[] create(Class key) {
                List result = ContainerUtil.newSmartList();
                for (Class bindingClass : PsiReferenceRegistrarImpl.this.myBindingsMap.keySet()) {
                    if (!bindingClass.isAssignableFrom(key)) continue;
                    result.add(PsiReferenceRegistrarImpl.this.myBindingsMap.get(bindingClass));
                }
                for (Class bindingClass : PsiReferenceRegistrarImpl.this.myNamedBindingsMap.keySet()) {
                    if (!bindingClass.isAssignableFrom(key)) continue;
                    result.add(PsiReferenceRegistrarImpl.this.myNamedBindingsMap.get(bindingClass));
                }
                if (language != Language.ANY) {
                    PsiReferenceRegistrar anyRegistrar = ReferenceProvidersRegistry.getInstance().getRegistrar(Language.ANY);
                    Collections.addAll(result, (Object[])((PsiReferenceRegistrarImpl)anyRegistrar).myBindingCache.get((Object)key));
                }
                return result.toArray(new ProviderBinding[result.size()]);
            }
        };
    }

    public void markInitialized() {
        this.myInitialized = true;
    }

    public <T extends PsiElement> void registerReferenceProvider(@NotNull ElementPattern<T> pattern, @NotNull PsiReferenceProvider provider, double priority) {
        SimpleProviderBinding providerBinding;
        if (this.myInitialized && !ApplicationManager.getApplication().isUnitTestMode()) {
            LOG.error("Reference provider registration is only allowed from PsiReferenceContributor");
        }
        Class scope = pattern.getCondition().getInitialCondition().getAcceptedClass();
        List conditions = pattern.getCondition().getConditions();
        for (PatternCondition _condition : conditions) {
            if (!(_condition instanceof PsiNamePatternCondition)) continue;
            PsiNamePatternCondition nameCondition = (PsiNamePatternCondition)_condition;
            List conditions1 = nameCondition.getNamePattern().getCondition().getConditions();
            for (PatternCondition condition1 : conditions1) {
                if (condition1 instanceof ValuePatternCondition) {
                    Collection strings = ((ValuePatternCondition)condition1).getValues();
                    this.registerNamedReferenceProvider(ArrayUtil.toStringArray((Collection)strings), nameCondition, scope, true, provider, priority, pattern);
                    return;
                }
                if (!(condition1 instanceof CaseInsensitiveValuePatternCondition)) continue;
                String[] strings = ((CaseInsensitiveValuePatternCondition)condition1).getValues();
                this.registerNamedReferenceProvider(strings, nameCondition, scope, false, provider, priority, pattern);
                return;
            }
        }
        if ((providerBinding = this.myBindingsMap.get(scope)) == null) {
            providerBinding = new SimpleProviderBinding();
            this.myBindingsMap.put(scope, providerBinding);
        }
        providerBinding.registerProvider(provider, pattern, priority);
        this.myBindingCache.clear();
    }

    public void unregisterReferenceProvider(@NotNull Class scope, @NotNull PsiReferenceProvider provider) {
        this.myBindingsMap.get(scope).unregisterProvider(provider);
    }

    private void registerNamedReferenceProvider(@NotNull String[] names, final PsiNamePatternCondition<?> nameCondition, @NotNull Class scopeClass, boolean caseSensitive, @NotNull PsiReferenceProvider provider, double priority, @NotNull ElementPattern pattern) {
        NamedObjectProviderBinding providerBinding = this.myNamedBindingsMap.get(scopeClass);
        if (providerBinding == null) {
            providerBinding = new NamedObjectProviderBinding(){

                @Override
                protected String getName(@NotNull PsiElement position) {
                    return nameCondition.getPropertyValue((Object)position);
                }
            };
            this.myNamedBindingsMap.put(scopeClass, providerBinding);
        }
        providerBinding.registerProvider(names, pattern, caseSensitive, provider, priority);
    }

    public void registerReferenceProvider(@NotNull Class scope, @NotNull PsiReferenceProvider provider) {
        this.registerReferenceProvider((ElementPattern)PlatformPatterns.psiElement((Class)scope), provider, 0.0);
    }

    @NotNull
    List<ProviderBinding.ProviderInfo<ProcessingContext>> getPairsByElement(@NotNull PsiElement element, @NotNull PsiReferenceService.Hints hints) {
        ProviderBinding[] bindings = (ProviderBinding[])this.myBindingCache.get(element.getClass());
        if (bindings.length == 0) {
            return Collections.emptyList();
        }
        List ret = ContainerUtil.newSmartList();
        for (ProviderBinding binding : bindings) {
            binding.addAcceptableReferenceProviders(element, ret, hints);
        }
        return ret;
    }
}

