/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiImportStaticReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.source.resolve.Domination;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.scope.BaseScopeProcessor;
import com.intellij.psi.scope.NameHint;
import com.intellij.util.SmartList;
import java.util.List;
import java.util.ListIterator;
import org.jetbrains.annotations.NotNull;

public class StaticImportResolveProcessor
extends BaseScopeProcessor
implements NameHint {
    private final PsiImportStaticReferenceElement myReference;
    private final String myName;
    private final List<JavaResolveResult> myFieldResults = new SmartList();
    private final List<JavaResolveResult> myClassResult = new SmartList();
    private final List<JavaResolveResult> myResults = new SmartList();

    public StaticImportResolveProcessor(@NotNull PsiImportStaticReferenceElement reference) {
        this.myReference = reference;
        this.myName = this.myReference.getReferenceName();
    }

    public boolean execute(@NotNull PsiElement candidate, @NotNull ResolveState state) {
        if (candidate instanceof PsiMember && ((PsiModifierListOwner)candidate).hasModifierProperty("static")) {
            if (candidate instanceof PsiField) {
                if (StaticImportResolveProcessor.checkDomination((PsiMember)candidate, this.myFieldResults)) {
                    return true;
                }
                this.myFieldResults.add((JavaResolveResult)new OurResolveResult(candidate, this.myReference));
            } else if (candidate instanceof PsiClass) {
                if (StaticImportResolveProcessor.checkDomination((PsiMember)candidate, this.myClassResult)) {
                    return true;
                }
                this.myClassResult.add((JavaResolveResult)new OurResolveResult(candidate, this.myReference));
            } else {
                this.myResults.add((JavaResolveResult)new OurResolveResult(candidate, this.myReference));
            }
        }
        return true;
    }

    private static boolean checkDomination(PsiMember candidate, List<JavaResolveResult> results) {
        if (!results.isEmpty()) {
            ListIterator<JavaResolveResult> i = results.listIterator(results.size());
            while (i.hasPrevious()) {
                Domination domination = StaticImportResolveProcessor.dominates(candidate, (PsiMember)i.previous().getElement());
                if (domination == Domination.DOMINATED_BY) {
                    return true;
                }
                if (domination != Domination.DOMINATES) continue;
                i.remove();
            }
        }
        return false;
    }

    private static Domination dominates(PsiMember member1, PsiMember member2) {
        PsiClass class1 = member1.getContainingClass();
        PsiClass class2 = member2.getContainingClass();
        if (class1 != null && class2 != null) {
            if (class1.isInheritor(class2, true)) {
                return Domination.DOMINATES;
            }
            if (class2.isInheritor(class1, true)) {
                return Domination.DOMINATED_BY;
            }
        }
        return Domination.EQUAL;
    }

    @Override
    public String getName(@NotNull ResolveState state) {
        return this.myName;
    }

    @Override
    public <T> T getHint(@NotNull Key<T> hintKey) {
        if (hintKey == NameHint.KEY) {
            return (T)this;
        }
        return super.getHint(hintKey);
    }

    public JavaResolveResult[] getResults() {
        if (this.myResults.size() + this.myFieldResults.size() + this.myClassResult.size() > 1) {
            StaticImportResolveProcessor.filterInvalid(this.myResults);
            StaticImportResolveProcessor.filterInvalid(this.myFieldResults);
            StaticImportResolveProcessor.filterInvalid(this.myClassResult);
        }
        if (!this.myFieldResults.isEmpty()) {
            this.myResults.addAll(this.myFieldResults);
        }
        if (!this.myClassResult.isEmpty()) {
            this.myResults.addAll(this.myClassResult);
        }
        return this.myResults.toArray(new JavaResolveResult[this.myResults.size()]);
    }

    private static void filterInvalid(List<JavaResolveResult> resultList) {
        if (resultList.isEmpty()) {
            return;
        }
        ListIterator<JavaResolveResult> i = resultList.listIterator(resultList.size());
        while (i.hasPrevious()) {
            if (i.previous().isValidResult()) continue;
            i.remove();
        }
    }

    private static class OurResolveResult
    extends CandidateInfo {
        private final PsiImportStaticReferenceElement myReference;

        public OurResolveResult(@NotNull PsiElement candidate, PsiImportStaticReferenceElement reference) {
            super(candidate, PsiSubstitutor.EMPTY);
            this.myReference = reference;
        }

        public boolean isAccessible() {
            PsiResolveHelper resolveHelper = JavaPsiFacade.getInstance((Project)this.myReference.getProject()).getResolveHelper();
            PsiElement element = this.getElement();
            return element instanceof PsiMember && resolveHelper.isAccessible((PsiMember)element, (PsiElement)this.myReference, null);
        }

        public boolean isStaticsScopeCorrect() {
            return true;
        }
    }
}

