/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.Trinity;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.AnyPsiChangeListener;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.util.containers.ConcurrentWeakKeySoftValueHashMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBus;
import java.lang.ref.ReferenceQueue;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResolveCache {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.resolve.ResolveCache");
    private final ConcurrentMap[] myMaps = new ConcurrentWeakKeySoftValueHashMap[8];
    private final RecursionGuard myGuard = RecursionManager.createGuard((String)"resolveCache");
    private static final Object NULL_RESULT = new Object();
    private static final StrongValueReference NULL_VALUE_REFERENCE = new StrongValueReference(NULL_RESULT);
    private static final StrongValueReference EMPTY_RESOLVE_RESULT = new StrongValueReference(ResolveResult.EMPTY_ARRAY);

    public static ResolveCache getInstance(Project project2) {
        ProgressIndicatorProvider.checkCanceled();
        return (ResolveCache)ServiceManager.getService((Project)project2, ResolveCache.class);
    }

    public ResolveCache(@NotNull MessageBus messageBus) {
        for (int i = 0; i < this.myMaps.length; ++i) {
            this.myMaps[i] = ResolveCache.createWeakMap();
        }
        messageBus.connect().subscribe(PsiManagerImpl.ANY_PSI_CHANGE_TOPIC, (Object)new AnyPsiChangeListener.Adapter(){

            @Override
            public void beforePsiChanged(boolean isPhysical) {
                ResolveCache.this.clearCache(isPhysical);
            }
        });
    }

    @NotNull
    private static <K, V> ConcurrentMap<K, V> createWeakMap() {
        return new ConcurrentWeakKeySoftValueHashMap<K, V>(100, 0.75f, Runtime.getRuntime().availableProcessors(), ContainerUtil.canonicalStrategy()){

            @NotNull
            protected ConcurrentWeakKeySoftValueHashMap.ValueReference<K, V> createValueReference(@NotNull V value, @NotNull ReferenceQueue<V> queue) {
                StrongValueReference result = value == NULL_RESULT || value instanceof Object[] && ((Object[])value).length == 0 ? ResolveCache.createStrongReference(value) : super.createValueReference(value, queue);
                return result;
            }

            public V get(@NotNull Object key) {
                Object v = super.get(key);
                return v == NULL_RESULT ? null : v;
            }
        };
    }

    public void clearCache(boolean isPhysical) {
        int startIndex;
        for (int i = startIndex = isPhysical ? 0 : 1; i < 2; ++i) {
            for (int j = 0; j < 2; ++j) {
                for (int k = 0; k < 2; ++k) {
                    this.myMaps[i * 4 + j * 2 + k].clear();
                }
            }
        }
    }

    @Nullable
    private <TRef extends PsiReference, TResult> TResult resolve(final @NotNull TRef ref, final @NotNull AbstractResolver<TRef, TResult> resolver, boolean needToPreventRecursion, final boolean incompleteCode, boolean isPoly, boolean isPhysical) {
        int index;
        ConcurrentMap<TRef, TResult> map;
        Object result;
        ProgressIndicatorProvider.checkCanceled();
        if (isPhysical) {
            ApplicationManager.getApplication().assertReadAccessAllowed();
        }
        if ((result = (map = this.getMap(index = ResolveCache.getIndex(isPhysical, incompleteCode, isPoly))).get(ref)) != null) {
            return (TResult)result;
        }
        RecursionGuard.StackStamp stamp = this.myGuard.markStack();
        result = needToPreventRecursion ? this.myGuard.doPreventingRecursion((Object)Trinity.create(ref, (Object)incompleteCode, (Object)isPoly), true, new Computable<TResult>(){

            public TResult compute() {
                return resolver.resolve(ref, incompleteCode);
            }
        }) : resolver.resolve(ref, incompleteCode);
        PsiElement element = result instanceof ResolveResult ? ((ResolveResult)result).getElement() : null;
        LOG.assertTrue(element == null || element.isValid(), result);
        if (stamp.mayCacheNow()) {
            this.cache(ref, map, result);
        }
        return (TResult)result;
    }

    @NotNull
    public <T extends PsiPolyVariantReference> ResolveResult[] resolveWithCaching(@NotNull T ref, @NotNull PolyVariantResolver<T> resolver, boolean needToPreventRecursion, boolean incompleteCode) {
        return this.resolveWithCaching(ref, resolver, needToPreventRecursion, incompleteCode, ref.getElement().getContainingFile());
    }

    @NotNull
    public <T extends PsiPolyVariantReference> ResolveResult[] resolveWithCaching(@NotNull T ref, @NotNull PolyVariantResolver<T> resolver, boolean needToPreventRecursion, boolean incompleteCode, @NotNull PsiFile containingFile) {
        ResolveResult[] result = (ResolveResult[])this.resolve((PsiReference)ref, (AbstractResolver)resolver, needToPreventRecursion, incompleteCode, true, containingFile.isPhysical());
        return result == null ? ResolveResult.EMPTY_ARRAY : result;
    }

    @NotNull
    public <T extends PsiPolyVariantReference> ResolveResult[] resolveWithCaching(final @NotNull T ref, final @NotNull PolyVariantContextResolver<T> resolver, boolean needToPreventRecursion, final boolean incompleteCode, final @NotNull PsiFile containingFile) {
        ProgressIndicatorProvider.checkCanceled();
        ApplicationManager.getApplication().assertReadAccessAllowed();
        int index = ResolveCache.getIndex(containingFile.isPhysical(), incompleteCode, true);
        ConcurrentMap map = this.getMap(index);
        ResolveResult[] result = (ResolveResult[])map.get(ref);
        if (result != null) {
            return result;
        }
        RecursionGuard.StackStamp stamp = this.myGuard.markStack();
        ResolveResult[] resolveResultArray = result = needToPreventRecursion ? (ResolveResult[])this.myGuard.doPreventingRecursion((Object)Pair.create(ref, (Object)incompleteCode), true, (Computable)new Computable<ResolveResult[]>(){

            public ResolveResult[] compute() {
                return resolver.resolve(ref, containingFile, incompleteCode);
            }
        }) : resolver.resolve(ref, containingFile, incompleteCode);
        if (stamp.mayCacheNow()) {
            this.cache((PsiReference)ref, map, (Object)result);
        }
        return result == null ? ResolveResult.EMPTY_ARRAY : result;
    }

    @Nullable
    public <T extends PsiPolyVariantReference> ResolveResult[] getCachedResults(@NotNull T ref, boolean physical, boolean incompleteCode, boolean isPoly) {
        ConcurrentMap map = this.getMap(ResolveCache.getIndex(physical, incompleteCode, isPoly));
        return (ResolveResult[])map.get(ref);
    }

    @Nullable
    public <TRef extends PsiReference, TResult> TResult resolveWithCaching(@NotNull TRef ref, @NotNull AbstractResolver<TRef, TResult> resolver, boolean needToPreventRecursion, boolean incompleteCode) {
        return this.resolve(ref, resolver, needToPreventRecursion, incompleteCode, false, ref.getElement().isPhysical());
    }

    @NotNull
    private <TRef extends PsiReference, TResult> ConcurrentMap<TRef, TResult> getMap(int index) {
        return this.myMaps[index];
    }

    private static int getIndex(boolean physical, boolean incompleteCode, boolean isPoly) {
        return (physical ? 0 : 1) * 4 + (incompleteCode ? 0 : 1) * 2 + (isPoly ? 0 : 1);
    }

    private <TRef extends PsiReference, TResult> void cache(@NotNull TRef ref, @NotNull ConcurrentMap<TRef, TResult> map, TResult result) {
        Object cached = map.get(ref);
        if (cached != null && cached == result) {
            return;
        }
        cached = result == null ? NULL_RESULT : result;
        map.put(ref, cached);
    }

    @NotNull
    private static <K, V> StrongValueReference<K, V> createStrongReference(@NotNull V value) {
        return value == NULL_RESULT ? NULL_VALUE_REFERENCE : (value == ResolveResult.EMPTY_ARRAY ? EMPTY_RESOLVE_RESULT : new StrongValueReference(value));
    }

    private static class StrongValueReference<K, V>
    implements ConcurrentWeakKeySoftValueHashMap.ValueReference<K, V> {
        private final V myValue;

        public StrongValueReference(@NotNull V value) {
            this.myValue = value;
        }

        @NotNull
        public ConcurrentWeakKeySoftValueHashMap.KeyReference<K, V> getKeyReference() {
            throw new UnsupportedOperationException();
        }

        public V get() {
            return this.myValue;
        }
    }

    public static interface Resolver
    extends AbstractResolver<PsiReference, PsiElement> {
    }

    public static interface PolyVariantContextResolver<T extends PsiPolyVariantReference> {
        @NotNull
        public ResolveResult[] resolve(@NotNull T var1, @NotNull PsiFile var2, boolean var3);
    }

    public static interface PolyVariantResolver<T extends PsiPolyVariantReference>
    extends AbstractResolver<T, ResolveResult[]> {
        @Override
        @NotNull
        public ResolveResult[] resolve(@NotNull T var1, boolean var2);
    }

    public static interface AbstractResolver<TRef extends PsiReference, TResult> {
        public TResult resolve(@NotNull TRef var1, boolean var2);
    }
}

