/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.parsing.xml;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.LighterASTNode;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiBuilderFactory;
import com.intellij.lang.impl.PsiBuilderImpl;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.source.parsing.xml.XmlBuilder;
import com.intellij.psi.impl.source.parsing.xml.XmlParsing;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.containers.Stack;
import com.intellij.util.diff.FlyweightCapableTreeStructure;
import com.intellij.xml.util.XmlUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class XmlBuilderDriver {
    private final Stack<String> myNamespacesStack = new Stack();
    private final Stack<String> myPrefixesStack = new Stack();
    private final CharSequence myText;
    @NonNls
    private static final String XMLNS = "xmlns";
    @NonNls
    private static final String XMLNS_COLON = "xmlns:";

    public XmlBuilderDriver(CharSequence text) {
        this.myText = text;
    }

    protected CharSequence getText() {
        return this.myText;
    }

    public void addImplicitBinding(@NonNls @NotNull String prefix, @NonNls @NotNull String namespace) {
        this.myNamespacesStack.push((Object)namespace);
        this.myPrefixesStack.push((Object)prefix);
    }

    public void build(XmlBuilder builder) {
        PsiBuilder b = this.createBuilderAndParse();
        FlyweightCapableTreeStructure structure = b.getLightTree();
        LighterASTNode root = (LighterASTNode)structure.getRoot();
        root = (LighterASTNode)structure.prepareForGetChildren((Object)root);
        Ref childrenRef = Ref.create(null);
        int count = structure.getChildren((Object)root, childrenRef);
        Object[] children2 = (LighterASTNode[])childrenRef.get();
        for (int i = 0; i < count; ++i) {
            LighterASTNode child = children2[i];
            IElementType tt = child.getTokenType();
            if (tt == XmlElementType.XML_TAG || tt == XmlElementType.HTML_TAG) {
                this.processTagNode(b, (FlyweightCapableTreeStructure<LighterASTNode>)structure, child, builder);
                continue;
            }
            if (tt != XmlElementType.XML_PROLOG) continue;
            this.processPrologNode(b, builder, (FlyweightCapableTreeStructure<LighterASTNode>)structure, child);
        }
        structure.disposeChildren(children2, count);
    }

    private void processPrologNode(PsiBuilder psiBuilder, XmlBuilder builder, FlyweightCapableTreeStructure<LighterASTNode> structure, LighterASTNode prolog) {
        Ref prologChildren = new Ref(null);
        int prologChildrenCount = structure.getChildren(structure.prepareForGetChildren((Object)prolog), prologChildren);
        for (int i = 0; i < prologChildrenCount; ++i) {
            LighterASTNode node = ((LighterASTNode[])prologChildren.get())[i];
            IElementType type = node.getTokenType();
            if (type == XmlElementType.XML_DOCTYPE) {
                this.processDoctypeNode(builder, structure, node);
                break;
            }
            if (type != TokenType.ERROR_ELEMENT) continue;
            this.processErrorNode(psiBuilder, node, builder);
        }
    }

    private void processDoctypeNode(XmlBuilder builder, FlyweightCapableTreeStructure<LighterASTNode> structure, LighterASTNode doctype) {
        Ref tokens = new Ref(null);
        int tokenCount = structure.getChildren(structure.prepareForGetChildren((Object)doctype), tokens);
        if (tokenCount > 0) {
            CharSequence publicId = null;
            boolean afterPublic = false;
            CharSequence systemId = null;
            boolean afterSystem = false;
            for (int i = 0; i < tokenCount; ++i) {
                LighterASTNode token = ((LighterASTNode[])tokens.get())[i];
                if (token.getTokenType() == XmlTokenType.XML_DOCTYPE_PUBLIC) {
                    afterPublic = true;
                    continue;
                }
                if (token.getTokenType() == XmlTokenType.XML_DOCTYPE_SYSTEM) {
                    afterSystem = true;
                    continue;
                }
                if (token.getTokenType() == TokenType.WHITE_SPACE || token.getTokenType() == XmlElementType.XML_COMMENT) continue;
                if (token.getTokenType() == XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN) {
                    if (afterPublic) {
                        publicId = this.getTokenText(token);
                    } else if (afterSystem) {
                        systemId = this.getTokenText(token);
                    }
                }
                afterSystem = false;
                afterPublic = false;
            }
            builder.doctype(publicId, systemId, doctype.getStartOffset(), doctype.getEndOffset());
        }
    }

    private CharSequence getTokenText(LighterASTNode token) {
        return this.myText.subSequence(token.getStartOffset(), token.getEndOffset());
    }

    protected PsiBuilder createBuilderAndParse() {
        ParserDefinition xmlParserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage((Language)XMLLanguage.INSTANCE);
        assert (xmlParserDefinition != null);
        PsiBuilder b = PsiBuilderFactory.getInstance().createBuilder(xmlParserDefinition, xmlParserDefinition.createLexer(null), this.myText);
        new XmlParsing(b).parseDocument();
        return b;
    }

    private void processErrorNode(PsiBuilder psiBuilder, LighterASTNode node, XmlBuilder builder) {
        assert (node.getTokenType() == TokenType.ERROR_ELEMENT);
        String message = PsiBuilderImpl.getErrorMessage(node);
        assert (message != null);
        builder.error(message, node.getStartOffset(), node.getEndOffset());
    }

    private void processTagNode(PsiBuilder psiBuilder, FlyweightCapableTreeStructure<LighterASTNode> structure, LighterASTNode node, XmlBuilder builder) {
        String namespace;
        CharSequence localName;
        XmlBuilder.ProcessingOrder order;
        IElementType nodeTT = node.getTokenType();
        assert (nodeTT == XmlElementType.XML_TAG || nodeTT == XmlElementType.HTML_TAG);
        node = (LighterASTNode)structure.prepareForGetChildren((Object)node);
        Ref childrenRef = Ref.create(null);
        int count = structure.getChildren((Object)node, childrenRef);
        Object[] children2 = (LighterASTNode[])childrenRef.get();
        int stackFrameSize = this.myNamespacesStack.size();
        CharSequence tagName = "";
        int headerEndOffset = node.getEndOffset();
        for (int i = 0; i < count; ++i) {
            LighterASTNode child = children2[i];
            IElementType tt = child.getTokenType();
            if (tt == XmlElementType.XML_ATTRIBUTE) {
                this.checkForXmlns(child, structure);
            }
            if (tt == XmlTokenType.XML_TAG_END || tt == XmlTokenType.XML_EMPTY_ELEMENT_END) {
                headerEndOffset = child.getEndOffset();
                break;
            }
            if (tt != XmlTokenType.XML_NAME && tt != XmlTokenType.XML_TAG_NAME) continue;
            tagName = this.getTokenText(child);
        }
        boolean processAttrs = (order = builder.startTag(localName = XmlUtil.getLocalName(tagName), namespace = this.getNamespace(tagName), node.getStartOffset(), node.getEndOffset(), headerEndOffset)) == XmlBuilder.ProcessingOrder.TAGS_AND_ATTRIBUTES || order == XmlBuilder.ProcessingOrder.TAGS_AND_ATTRIBUTES_AND_TEXTS;
        boolean processTexts = order == XmlBuilder.ProcessingOrder.TAGS_AND_TEXTS || order == XmlBuilder.ProcessingOrder.TAGS_AND_ATTRIBUTES_AND_TEXTS;
        for (int i = 0; i < count; ++i) {
            LighterASTNode child = children2[i];
            IElementType tt = child.getTokenType();
            if (tt == TokenType.ERROR_ELEMENT) {
                this.processErrorNode(psiBuilder, child, builder);
            }
            if (tt == XmlElementType.XML_TAG || tt == XmlElementType.HTML_TAG) {
                this.processTagNode(psiBuilder, structure, child, builder);
            }
            if (processAttrs && tt == XmlElementType.XML_ATTRIBUTE) {
                this.processAttributeNode(child, structure, builder);
            }
            if (processTexts && tt == XmlElementType.XML_TEXT) {
                this.processTextNode(structure, child, builder);
            }
            if (tt != XmlElementType.XML_ENTITY_REF) continue;
            builder.entityRef(this.getTokenText(child), child.getStartOffset(), child.getEndOffset());
        }
        builder.endTag(localName, namespace, node.getStartOffset(), node.getEndOffset());
        int framesToDrop = this.myNamespacesStack.size() - stackFrameSize;
        for (int i = 0; i < framesToDrop; ++i) {
            this.myNamespacesStack.pop();
            this.myPrefixesStack.pop();
        }
        structure.disposeChildren(children2, count);
    }

    private void processTextNode(FlyweightCapableTreeStructure<LighterASTNode> structure, LighterASTNode node, XmlBuilder builder) {
        node = (LighterASTNode)structure.prepareForGetChildren((Object)node);
        Ref childrenRef = Ref.create(null);
        int count = structure.getChildren((Object)node, childrenRef);
        Object[] children2 = (LighterASTNode[])childrenRef.get();
        for (int i = 0; i < count; ++i) {
            LighterASTNode child = children2[i];
            IElementType tt = child.getTokenType();
            int start = child.getStartOffset();
            int end = child.getEndOffset();
            CharSequence physical = this.getTokenText(child);
            if (XmlTokenType.COMMENTS.contains(tt)) continue;
            if (tt == XmlTokenType.XML_CDATA_START || tt == XmlTokenType.XML_CDATA_END) {
                builder.textElement("", physical, start, end);
                continue;
            }
            if (tt == XmlElementType.XML_CDATA) {
                this.processTextNode(structure, child, builder);
                continue;
            }
            if (tt == XmlTokenType.XML_CHAR_ENTITY_REF) {
                builder.textElement(new String(new char[]{XmlUtil.getCharFromEntityRef(physical.toString())}), physical, start, end);
                continue;
            }
            builder.textElement(physical, physical, start, end);
        }
        structure.disposeChildren(children2, count);
    }

    private void processAttributeNode(LighterASTNode attrNode, FlyweightCapableTreeStructure<LighterASTNode> structure, XmlBuilder builder) {
        builder.attribute(this.getAttributeName(attrNode, structure), this.getAttributeValue(attrNode, structure), attrNode.getStartOffset(), attrNode.getEndOffset());
    }

    private String getNamespace(CharSequence tagName) {
        int pos = StringUtil.indexOf((CharSequence)tagName, (char)':');
        String namespacePrefix = pos == -1 ? "" : tagName.subSequence(0, pos).toString();
        for (int i = this.myPrefixesStack.size() - 1; i >= 0; --i) {
            if (!namespacePrefix.equals(this.myPrefixesStack.get(i))) continue;
            return (String)this.myNamespacesStack.get(i);
        }
        return "";
    }

    private void checkForXmlns(LighterASTNode attrNode, FlyweightCapableTreeStructure<LighterASTNode> structure) {
        CharSequence name = this.getAttributeName(attrNode, structure);
        if (Comparing.equal((CharSequence)name, (CharSequence)XMLNS)) {
            this.myPrefixesStack.push((Object)"");
            this.myNamespacesStack.push((Object)this.getAttributeValue(attrNode, structure).toString());
        } else if (StringUtil.startsWith((CharSequence)name, (CharSequence)XMLNS_COLON)) {
            this.myPrefixesStack.push((Object)name.subSequence(XMLNS_COLON.length(), name.length()).toString());
            this.myNamespacesStack.push((Object)this.getAttributeValue(attrNode, structure).toString());
        }
    }

    private CharSequence getAttributeName(LighterASTNode attrNode, FlyweightCapableTreeStructure<LighterASTNode> structure) {
        return this.findTextByTokenType(attrNode, structure, XmlTokenType.XML_NAME);
    }

    private CharSequence getAttributeValue(LighterASTNode attrNode, FlyweightCapableTreeStructure<LighterASTNode> structure) {
        CharSequence fullValue = this.findTextByTokenType(attrNode, structure, XmlElementType.XML_ATTRIBUTE_VALUE);
        int start = 0;
        if (fullValue.length() > 0 && fullValue.charAt(0) == '\"') {
            ++start;
        }
        int end = fullValue.length();
        if (fullValue.length() > start && fullValue.charAt(fullValue.length() - 1) == '\"') {
            --end;
        }
        return fullValue.subSequence(start, end);
    }

    private CharSequence findTextByTokenType(LighterASTNode attrNode, FlyweightCapableTreeStructure<LighterASTNode> structure, IElementType tt) {
        attrNode = (LighterASTNode)structure.prepareForGetChildren((Object)attrNode);
        Ref childrenRef = Ref.create(null);
        int count = structure.getChildren((Object)attrNode, childrenRef);
        Object[] children2 = (LighterASTNode[])childrenRef.get();
        CharSequence name = "";
        for (int i = 0; i < count; ++i) {
            LighterASTNode child = children2[i];
            if (child.getTokenType() != tt) continue;
            name = this.getTokenText(child);
            break;
        }
        structure.disposeChildren(children2, count);
        return name;
    }
}

