/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.codeStyle.javadoc;

import com.intellij.formatting.IndentInfo;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.impl.source.codeStyle.javadoc.CommentFormatter;
import com.intellij.psi.impl.source.codeStyle.javadoc.JDComment;
import com.intellij.psi.impl.source.codeStyle.javadoc.JDTag;
import com.intellij.psi.impl.source.codeStyle.javadoc.NameDesc;
import com.intellij.util.containers.ContainerUtilRt;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JDParamListOwnerComment
extends JDComment {
    protected List<NameDesc> myParamsList;

    public JDParamListOwnerComment(@NotNull CommentFormatter formatter) {
        super(formatter);
    }

    @Override
    protected void generateSpecial(@NotNull String prefix, @NotNull StringBuilder sb) {
        if (this.myParamsList != null) {
            int before = sb.length();
            this.generateList(prefix, sb, this.myParamsList, JDTag.PARAM.getWithEndWhitespace(), this.myFormatter.getSettings().JD_ALIGN_PARAM_COMMENTS, this.myFormatter.getSettings().JD_KEEP_EMPTY_PARAMETER, this.myFormatter.getSettings().JD_PARAM_DESCRIPTION_ON_NEW_LINE);
            int size = sb.length() - before;
            if (size > 0 && this.myFormatter.getSettings().JD_ADD_BLANK_AFTER_PARM_COMMENTS) {
                sb.append(prefix);
                sb.append('\n');
            }
        }
    }

    @Nullable
    public NameDesc getParameter(@Nullable String name) {
        return JDParamListOwnerComment.getNameDesc(name, this.myParamsList);
    }

    public void addParameter(@NotNull String name, @Nullable String description) {
        if (this.myParamsList == null) {
            this.myParamsList = ContainerUtilRt.newArrayList();
        }
        this.myParamsList.add(new NameDesc(name, description));
    }

    @Nullable
    private static NameDesc getNameDesc(@Nullable String name, @Nullable List<NameDesc> list) {
        if (list == null) {
            return null;
        }
        for (NameDesc aList : list) {
            if (!aList.name.equals(name)) continue;
            return aList;
        }
        return null;
    }

    protected void generateList(@NotNull String prefix, @NotNull StringBuilder sb, @NotNull List<NameDesc> list, @NotNull String tag, boolean align_comments, boolean generate_empty_tags, boolean wrapDescription) {
        CodeStyleSettings settings = this.myFormatter.getSettings();
        CommonCodeStyleSettings.IndentOptions indentOptions = settings.getIndentOptions((FileType)JavaFileType.INSTANCE);
        String continuationIndent = new IndentInfo(0, indentOptions.CONTINUATION_INDENT_SIZE, 0).generateNewWhiteSpace(indentOptions);
        int max = 0;
        if (align_comments && !wrapDescription) {
            for (NameDesc nd : list) {
                int currentLength = nd.name.length();
                if (JDParamListOwnerComment.isNull(nd.desc) && !generate_empty_tags || currentLength <= max) continue;
                max = currentLength;
            }
        }
        StringBuilder fill = new StringBuilder(prefix.length() + tag.length() + max + 1);
        fill.append(prefix);
        StringUtil.repeatSymbol((Appendable)fill, (char)' ', (int)(max + 1 + tag.length()));
        String wrapParametersPrefix = prefix + continuationIndent;
        for (NameDesc nd : list) {
            if (JDParamListOwnerComment.isNull(nd.desc) && !generate_empty_tags) continue;
            if (wrapDescription && !JDParamListOwnerComment.isNull(nd.desc)) {
                sb.append(prefix).append(tag).append(nd.name).append("\n");
                sb.append(wrapParametersPrefix);
                sb.append((CharSequence)this.myFormatter.getParser().formatJDTagDescription(nd.desc, wrapParametersPrefix));
                continue;
            }
            if (align_comments) {
                sb.append(prefix);
                sb.append(tag);
                sb.append(nd.name);
                int spacesNumber = max + 1 - nd.name.length();
                StringUtil.repeatSymbol((Appendable)sb, (char)' ', (int)Math.max(0, spacesNumber));
                sb.append((CharSequence)this.myFormatter.getParser().formatJDTagDescription(nd.desc, fill));
                continue;
            }
            sb.append(prefix);
            String description = nd.desc == null ? "" : nd.desc;
            sb.append((CharSequence)this.myFormatter.getParser().formatJDTagDescription(tag + nd.name + " " + description, prefix));
        }
    }
}

