/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.codeStyle;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.ExternalizableSchemeAdapter;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.codeStyle.CodeStyleScheme;
import com.intellij.psi.codeStyle.CodeStyleSchemes;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CodeStyleSchemeImpl
extends ExternalizableSchemeAdapter
implements CodeStyleScheme {
    private static final Logger LOG = Logger.getInstance(CodeStyleSchemeImpl.class);
    private Element myRootElement;
    private String myParentSchemeName;
    private final boolean myIsDefault;
    private volatile CodeStyleSettings myCodeStyleSettings;

    public CodeStyleSchemeImpl(@NotNull String name, String parentSchemeName, Element rootElement) {
        this.myName = name;
        this.myRootElement = rootElement;
        this.myIsDefault = false;
        this.myParentSchemeName = parentSchemeName;
    }

    public CodeStyleSchemeImpl(@NotNull String name, boolean isDefault, CodeStyleScheme parentScheme) {
        this.myName = name;
        this.myIsDefault = isDefault;
        this.init(parentScheme, null);
    }

    public void init(@NotNull CodeStyleSchemes schemesManager) {
        LOG.assertTrue(this.myCodeStyleSettings == null, (Object)"Already initialized");
        this.init(this.myParentSchemeName == null ? null : schemesManager.findSchemeByName(this.myParentSchemeName), this.myRootElement);
        this.myParentSchemeName = null;
        this.myRootElement = null;
    }

    private void init(@Nullable CodeStyleScheme parentScheme, Element root) {
        if (parentScheme == null) {
            this.myCodeStyleSettings = new CodeStyleSettings();
        } else {
            CodeStyleSettings parentSettings = parentScheme.getCodeStyleSettings();
            this.myCodeStyleSettings = parentSettings.clone();
            while (parentSettings.getParentSettings() != null) {
                parentSettings = parentSettings.getParentSettings();
            }
            this.myCodeStyleSettings.setParentSettings(parentSettings);
        }
        if (root != null) {
            try {
                this.readExternal(root);
            }
            catch (InvalidDataException e) {
                LOG.error((Throwable)e);
            }
        }
    }

    public CodeStyleSettings getCodeStyleSettings() {
        return this.myCodeStyleSettings;
    }

    public void setCodeStyleSettings(@NotNull CodeStyleSettings codeStyleSettings) {
        this.myCodeStyleSettings = codeStyleSettings;
    }

    public boolean isDefault() {
        return this.myIsDefault;
    }

    public void writeExternal(Element element) throws WriteExternalException {
        this.myCodeStyleSettings.writeExternal(element);
    }

    public void readExternal(Element element) throws InvalidDataException {
        this.myCodeStyleSettings.readExternal(element);
    }
}

