/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.codeStyle;

import com.intellij.openapi.options.SchemeExporter;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.codeStyle.CodeStyleScheme;
import com.intellij.psi.impl.source.codeStyle.CodeStyleSchemeImpl;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.jetbrains.annotations.NotNull;

public class CodeStyleSchemeCopyExporter
extends SchemeExporter<CodeStyleScheme> {
    public void exportScheme(@NotNull CodeStyleScheme scheme, @NotNull OutputStream outputStream) throws Exception {
        assert (scheme instanceof CodeStyleSchemeImpl);
        CodeStyleSchemeCopyExporter.writeToStream(outputStream, CodeStyleSchemeCopyExporter.schemeToDom((CodeStyleSchemeImpl)scheme));
    }

    public String getExtension() {
        return "xml";
    }

    private static Element schemeToDom(@NotNull CodeStyleSchemeImpl scheme) throws WriteExternalException {
        Element newElement = new Element("code_scheme");
        newElement.setAttribute("name", scheme.getName());
        scheme.writeExternal(newElement);
        return newElement;
    }

    private static void writeToStream(@NotNull OutputStream outputStream, @NotNull Element element) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter(outputStream);
        Format format = Format.getPrettyFormat();
        format.setLineSeparator("\n");
        new XMLOutputter(format).output(element, (Writer)writer);
    }
}

