/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.impl.java.stubs.PsiClassReferenceListStub;
import com.intellij.psi.impl.source.JavaStubPsiElement;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.stubs.IStubElementType;
import org.jetbrains.annotations.NotNull;

public class PsiReferenceListImpl
extends JavaStubPsiElement<PsiClassReferenceListStub>
implements PsiReferenceList {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.PsiReferenceListImpl");

    public PsiReferenceListImpl(PsiClassReferenceListStub stub, IStubElementType nodeType) {
        super(stub, nodeType);
    }

    public PsiReferenceListImpl(ASTNode node) {
        super(node);
    }

    @NotNull
    public PsiJavaCodeReferenceElement[] getReferenceElements() {
        return (PsiJavaCodeReferenceElement[])this.calcTreeElement().getChildrenAsPsiElements(JavaElementType.JAVA_CODE_REFERENCE, PsiJavaCodeReferenceElement.ARRAY_FACTORY);
    }

    @NotNull
    public PsiClassType[] getReferencedTypes() {
        PsiClassReferenceListStub stub = (PsiClassReferenceListStub)this.getStub();
        if (stub != null) {
            return stub.getReferencedTypes();
        }
        PsiJavaCodeReferenceElement[] refs = this.getReferenceElements();
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)this.getProject()).getElementFactory();
        PsiClassType[] types = new PsiClassType[refs.length];
        for (int i = 0; i < types.length; ++i) {
            types[i] = factory.createType(refs[i]);
        }
        return types;
    }

    public PsiReferenceList.Role getRole() {
        IStubElementType type = this.getElementType();
        if (type == JavaElementType.EXTENDS_LIST) {
            return PsiReferenceList.Role.EXTENDS_LIST;
        }
        if (type == JavaElementType.IMPLEMENTS_LIST) {
            return PsiReferenceList.Role.IMPLEMENTS_LIST;
        }
        if (type == JavaElementType.THROWS_LIST) {
            return PsiReferenceList.Role.THROWS_LIST;
        }
        if (type == JavaElementType.EXTENDS_BOUND_LIST) {
            return PsiReferenceList.Role.EXTENDS_BOUNDS_LIST;
        }
        LOG.error("Unknown element type:" + type);
        return null;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitReferenceList((PsiReferenceList)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public String toString() {
        return "PsiReferenceList";
    }
}

