/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.PsiParameterListStub;
import com.intellij.psi.impl.source.Constants;
import com.intellij.psi.impl.source.JavaStubPsiElement;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.stubs.IStubElementType;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class PsiParameterListImpl
extends JavaStubPsiElement<PsiParameterListStub>
implements PsiParameterList {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.PsiParameterListImpl");

    public PsiParameterListImpl(@NotNull PsiParameterListStub stub) {
        super(stub, (IStubElementType)JavaStubElementTypes.PARAMETER_LIST);
    }

    public PsiParameterListImpl(@NotNull ASTNode node) {
        super(node);
    }

    @NotNull
    public PsiParameter[] getParameters() {
        return (PsiParameter[])this.getStubOrPsiChildren((IStubElementType)JavaStubElementTypes.PARAMETER, PsiParameter.ARRAY_FACTORY);
    }

    public int getParameterIndex(PsiParameter parameter) {
        LOG.assertTrue(parameter.getParent() == this);
        return PsiImplUtil.getParameterIndex(parameter, this);
    }

    @Override
    @NotNull
    public CompositeElement getNode() {
        return (CompositeElement)super.getNode();
    }

    public int getParametersCount() {
        PsiParameterListStub stub = (PsiParameterListStub)this.getStub();
        if (stub != null) {
            return stub.getChildrenStubs().size();
        }
        return this.getNode().countChildren(Constants.PARAMETER_BIT_SET);
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitParameterList((PsiParameterList)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    @NonNls
    public String toString() {
        return "PsiParameterList:" + this.getText();
    }
}

