/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.ItemPresentationProviders;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSyntheticClass;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.ElementPresentationUtil;
import com.intellij.psi.impl.PsiClassImplUtil;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.PsiSuperMethodImplUtil;
import com.intellij.psi.impl.cache.TypeInfo;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.PsiMethodStub;
import com.intellij.psi.impl.source.JavaStubPsiElement;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.JavaSharedImplUtil;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.reference.SoftReference;
import com.intellij.ui.RowIcon;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PlatformIcons;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiMethodImpl
extends JavaStubPsiElement<PsiMethodStub>
implements PsiMethod,
Queryable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.PsiMethodImpl");
    private SoftReference<PsiType> myCachedType = null;

    public PsiMethodImpl(PsiMethodStub stub) {
        this(stub, (IStubElementType)JavaStubElementTypes.METHOD);
    }

    protected PsiMethodImpl(PsiMethodStub stub, IStubElementType type) {
        super(stub, type);
    }

    public PsiMethodImpl(ASTNode node) {
        super(node);
    }

    @Override
    public void subtreeChanged() {
        super.subtreeChanged();
        this.dropCached();
    }

    protected void dropCached() {
        this.myCachedType = null;
    }

    @Override
    protected Object clone() {
        PsiMethodImpl clone = (PsiMethodImpl)((Object)super.clone());
        clone.dropCached();
        return clone;
    }

    public PsiClass getContainingClass() {
        PsiElement parent = this.getParent();
        return parent instanceof PsiClass ? (PsiClass)parent : (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)this, PsiSyntheticClass.class);
    }

    @Override
    public PsiElement getContext() {
        PsiClass cc = this.getContainingClass();
        return cc != null ? cc : super.getContext();
    }

    public PsiIdentifier getNameIdentifier() {
        return (PsiIdentifier)this.getNode().findChildByRoleAsPsiElement(9);
    }

    @NotNull
    public PsiMethod[] findSuperMethods() {
        return PsiSuperMethodImplUtil.findSuperMethods(this);
    }

    @NotNull
    public PsiMethod[] findSuperMethods(boolean checkAccess) {
        return PsiSuperMethodImplUtil.findSuperMethods((PsiMethod)this, checkAccess);
    }

    @NotNull
    public PsiMethod[] findSuperMethods(PsiClass parentClass) {
        return PsiSuperMethodImplUtil.findSuperMethods((PsiMethod)this, parentClass);
    }

    @NotNull
    public List<MethodSignatureBackedByPsiMethod> findSuperMethodSignaturesIncludingStatic(boolean checkAccess) {
        return PsiSuperMethodImplUtil.findSuperMethodSignaturesIncludingStatic(this, checkAccess);
    }

    public PsiMethod findDeepestSuperMethod() {
        return PsiSuperMethodImplUtil.findDeepestSuperMethod(this);
    }

    @NotNull
    public PsiMethod[] findDeepestSuperMethods() {
        return PsiSuperMethodImplUtil.findDeepestSuperMethods(this);
    }

    @Override
    @NotNull
    public String getName() {
        PsiIdentifier nameIdentifier;
        PsiMethodStub stub = (PsiMethodStub)this.getStub();
        String name = stub != null ? stub.getName() : ((nameIdentifier = this.getNameIdentifier()) == null ? null : nameIdentifier.getText());
        return name != null ? name : "<unnamed>";
    }

    @NotNull
    public HierarchicalMethodSignature getHierarchicalMethodSignature() {
        return PsiSuperMethodImplUtil.getHierarchicalMethodSignature(this);
    }

    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        PsiIdentifier identifier = this.getNameIdentifier();
        if (identifier == null) {
            throw new IncorrectOperationException("Empty name: " + (Object)((Object)this));
        }
        PsiImplUtil.setName((PsiElement)identifier, name);
        return this;
    }

    public PsiTypeElement getReturnTypeElement() {
        if (this.isConstructor()) {
            return null;
        }
        return (PsiTypeElement)this.getNode().findChildByRoleAsPsiElement(10);
    }

    public PsiTypeParameterList getTypeParameterList() {
        return (PsiTypeParameterList)this.getRequiredStubOrPsiChild(JavaStubElementTypes.TYPE_PARAMETER_LIST);
    }

    public boolean hasTypeParameters() {
        return PsiImplUtil.hasTypeParameters((PsiTypeParameterListOwner)this);
    }

    @NotNull
    public PsiTypeParameter[] getTypeParameters() {
        return PsiImplUtil.getTypeParameters((PsiTypeParameterListOwner)this);
    }

    public PsiType getReturnType() {
        if (this.isConstructor()) {
            return null;
        }
        PsiMethodStub stub = (PsiMethodStub)this.getStub();
        if (stub != null) {
            PsiType type = (PsiType)SoftReference.dereference(this.myCachedType);
            if (type != null) {
                return type;
            }
            String typeText = TypeInfo.createTypeText(stub.getReturnTypeText(true));
            if (typeText == null) {
                return null;
            }
            try {
                type = JavaPsiFacade.getInstance((Project)this.getProject()).getElementFactory().createTypeFromText(typeText, (PsiElement)this);
                this.myCachedType = new SoftReference((Object)type);
                return type;
            }
            catch (IncorrectOperationException e) {
                LOG.error("stub: " + stub + "; method: " + this.getText(), (Throwable)e);
                return null;
            }
        }
        this.myCachedType = null;
        PsiTypeElement typeElement = this.getReturnTypeElement();
        if (typeElement == null) {
            return null;
        }
        PsiParameterList parameterList = this.getParameterList();
        return JavaSharedImplUtil.getType(typeElement, (PsiElement)parameterList);
    }

    @NotNull
    public PsiModifierList getModifierList() {
        return (PsiModifierList)this.getRequiredStubOrPsiChild(JavaStubElementTypes.MODIFIER_LIST);
    }

    public boolean hasModifierProperty(@NotNull String name) {
        return this.getModifierList().hasModifierProperty(name);
    }

    @NotNull
    public PsiParameterList getParameterList() {
        return (PsiParameterList)this.getRequiredStubOrPsiChild(JavaStubElementTypes.PARAMETER_LIST);
    }

    @NotNull
    public PsiReferenceList getThrowsList() {
        return (PsiReferenceList)this.getRequiredStubOrPsiChild(JavaStubElementTypes.THROWS_LIST);
    }

    public PsiCodeBlock getBody() {
        return (PsiCodeBlock)this.getNode().findChildByRoleAsPsiElement(17);
    }

    @Override
    @NotNull
    public CompositeElement getNode() {
        return (CompositeElement)super.getNode();
    }

    public boolean isDeprecated() {
        PsiMethodStub stub = (PsiMethodStub)this.getStub();
        if (stub != null) {
            return stub.isDeprecated() || stub.hasDeprecatedAnnotation() && PsiImplUtil.isDeprecatedByAnnotation((PsiModifierListOwner)this);
        }
        return PsiImplUtil.isDeprecatedByDocTag((PsiDocCommentOwner)this) || PsiImplUtil.isDeprecatedByAnnotation((PsiModifierListOwner)this);
    }

    public PsiDocComment getDocComment() {
        PsiMethodStub stub = (PsiMethodStub)this.getStub();
        if (stub != null && !stub.hasDocComment()) {
            return null;
        }
        return (PsiDocComment)this.getNode().findChildByRoleAsPsiElement(7);
    }

    public boolean isConstructor() {
        PsiMethodStub stub = (PsiMethodStub)this.getStub();
        if (stub != null) {
            return stub.isConstructor();
        }
        return this.getNode().findChildByRole(10) == null;
    }

    public boolean isVarArgs() {
        PsiMethodStub stub = (PsiMethodStub)this.getStub();
        if (stub != null) {
            return stub.isVarArgs();
        }
        return PsiImplUtil.isVarArgs(this);
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitMethod((PsiMethod)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public String toString() {
        return "PsiMethod:" + this.getName();
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor2, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        return PsiImplUtil.processDeclarationsInMethod(this, processor2, state, lastParent, place);
    }

    @NotNull
    public MethodSignature getSignature(@NotNull PsiSubstitutor substitutor) {
        if (substitutor == PsiSubstitutor.EMPTY) {
            return (MethodSignature)CachedValuesManager.getCachedValue((PsiElement)this, (CachedValueProvider)new CachedValueProvider<MethodSignature>(){

                @Nullable
                public CachedValueProvider.Result<MethodSignature> compute() {
                    MethodSignatureBackedByPsiMethod signature = MethodSignatureBackedByPsiMethod.create((PsiMethod)PsiMethodImpl.this, (PsiSubstitutor)PsiSubstitutor.EMPTY);
                    return CachedValueProvider.Result.create((Object)signature, (Object[])new Object[]{PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT});
                }
            });
        }
        return MethodSignatureBackedByPsiMethod.create((PsiMethod)this, (PsiSubstitutor)substitutor);
    }

    @Override
    public PsiElement getOriginalElement() {
        PsiMethod originalMethod;
        PsiElement original;
        PsiClass containingClass = this.getContainingClass();
        if (containingClass != null && (original = containingClass.getOriginalElement()) != containingClass && (originalMethod = ((PsiClass)original).findMethodBySignature((PsiMethod)this, false)) != null) {
            return originalMethod;
        }
        return this;
    }

    @Override
    public ItemPresentation getPresentation() {
        return ItemPresentationProviders.getItemPresentation((NavigationItem)this);
    }

    public Icon getElementIcon(int flags) {
        Icon methodIcon = this.hasModifierProperty("abstract") ? PlatformIcons.ABSTRACT_METHOD_ICON : PlatformIcons.METHOD_ICON;
        RowIcon baseIcon = ElementPresentationUtil.createLayeredIcon(methodIcon, (PsiModifierListOwner)this, false);
        return ElementPresentationUtil.addVisibilityIcon((PsiModifierListOwner)this, flags, baseIcon);
    }

    @Override
    public boolean isEquivalentTo(PsiElement another) {
        return PsiClassImplUtil.isMethodEquivalentTo(this, another);
    }

    @Override
    @NotNull
    public SearchScope getUseScope() {
        return (SearchScope)ApplicationManager.getApplication().runReadAction((Computable)new Computable<SearchScope>(){

            public SearchScope compute() {
                return PsiImplUtil.getMemberUseScope((PsiMember)PsiMethodImpl.this);
            }
        });
    }

    public void putInfo(@NotNull Map<String, String> info) {
        info.put("methodName", this.getName());
    }

    protected boolean isVisibilitySupported() {
        return true;
    }
}

