/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionCodeFragment;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.PsiCodeFragmentImpl;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiExpressionCodeFragmentImpl
extends PsiCodeFragmentImpl
implements PsiExpressionCodeFragment {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.PsiExpressionCodeFragmentImpl");
    private PsiType myExpectedType;

    public PsiExpressionCodeFragmentImpl(@NotNull Project project2, boolean isPhysical, @NonNls String name, @NotNull CharSequence text, @Nullable PsiType expectedType, @Nullable PsiElement context) {
        super(project2, JavaElementType.EXPRESSION_TEXT, isPhysical, name, text, context);
        this.setExpectedType(expectedType);
    }

    @Nullable
    public PsiExpression getExpression() {
        ASTNode exprChild = this.calcTreeElement().findChildByType(ElementType.EXPRESSION_BIT_SET);
        if (exprChild == null) {
            return null;
        }
        return (PsiExpression)SourceTreeToPsiMap.treeElementToPsi(exprChild);
    }

    public PsiType getExpectedType() {
        PsiType type = this.myExpectedType;
        if (type != null && !type.isValid()) {
            return null;
        }
        return type;
    }

    public void setExpectedType(@Nullable PsiType type) {
        this.myExpectedType = type;
        if (type != null) {
            LOG.assertTrue(type.isValid());
        }
    }
}

