/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.TypeAnnotationProvider;
import com.intellij.psi.impl.light.LightClassReference;
import com.intellij.psi.impl.source.PsiImmediateClassType;
import com.intellij.psi.impl.source.PsiJavaCodeReferenceElementImpl;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.SmartList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PsiClassReferenceType
extends PsiClassType.Stub {
    private final PsiJavaCodeReferenceElement myReference;

    public PsiClassReferenceType(@NotNull PsiJavaCodeReferenceElement reference, LanguageLevel level) {
        this(reference, level, PsiClassReferenceType.collectAnnotations(reference));
    }

    public PsiClassReferenceType(@NotNull PsiJavaCodeReferenceElement reference, LanguageLevel level, @NotNull PsiAnnotation[] annotations) {
        super(level, annotations);
        this.myReference = reference;
    }

    public PsiClassReferenceType(@NotNull PsiJavaCodeReferenceElement reference, LanguageLevel level, @NotNull TypeAnnotationProvider annotations) {
        super(level, annotations);
        this.myReference = reference;
    }

    private static PsiAnnotation[] collectAnnotations(PsiJavaCodeReferenceElement reference) {
        List result = null;
        for (PsiElement child = reference.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof PsiAnnotation)) continue;
            if (result == null) {
                result = new SmartList();
            }
            result.add((PsiAnnotation)child);
        }
        return result == null ? PsiAnnotation.EMPTY_ARRAY : result.toArray(new PsiAnnotation[result.size()]);
    }

    public boolean isValid() {
        return this.myReference.isValid();
    }

    public boolean equalsToText(@NotNull String text) {
        return Comparing.equal((String)text, (String)this.getCanonicalText());
    }

    @NotNull
    public GlobalSearchScope getResolveScope() {
        return this.myReference.getResolveScope();
    }

    @NotNull
    public LanguageLevel getLanguageLevel() {
        if (this.myLanguageLevel != null) {
            return this.myLanguageLevel;
        }
        return PsiUtil.getLanguageLevel((PsiElement)this.myReference);
    }

    @NotNull
    public PsiClassType setLanguageLevel(@NotNull LanguageLevel languageLevel) {
        if (languageLevel.equals((Object)this.myLanguageLevel)) {
            return this;
        }
        return new PsiClassReferenceType(this.myReference, languageLevel, this.getAnnotationProvider());
    }

    public PsiClass resolve() {
        return this.resolveGenerics().getElement();
    }

    @NotNull
    public PsiClassType.ClassResolveResult resolveGenerics() {
        PsiUtilCore.ensureValid((PsiElement)this.myReference);
        JavaResolveResult result = this.myReference.advancedResolve(false);
        return result.getElement() == null ? PsiClassType.ClassResolveResult.EMPTY : new DelegatingClassResolveResult(result);
    }

    @NotNull
    public PsiClassType rawType() {
        PsiElement resolved = this.myReference.resolve();
        if (resolved instanceof PsiClass) {
            PsiClass aClass = (PsiClass)resolved;
            if (!PsiUtil.typeParametersIterable((PsiTypeParameterListOwner)aClass).iterator().hasNext()) {
                return this;
            }
            PsiManager manager = this.myReference.getManager();
            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory();
            PsiSubstitutor rawSubstitutor = factory.createRawSubstitutor((PsiTypeParameterListOwner)aClass);
            return new PsiImmediateClassType(aClass, rawSubstitutor, this.getLanguageLevel(), this.getAnnotationProvider());
        }
        String qualifiedName = this.myReference.getQualifiedName();
        String name = this.myReference.getReferenceName();
        if (name == null) {
            name = "";
        }
        LightClassReference reference = new LightClassReference(this.myReference.getManager(), name, qualifiedName, this.myReference.getResolveScope());
        return new PsiClassReferenceType((PsiJavaCodeReferenceElement)reference, null, this.getAnnotationProvider());
    }

    public String getClassName() {
        return this.myReference.getReferenceName();
    }

    @NotNull
    public PsiType[] getParameters() {
        return this.myReference.getTypeParameters();
    }

    @NotNull
    public PsiClassType createImmediateCopy() {
        PsiClassType.ClassResolveResult resolveResult = this.resolveGenerics();
        PsiClass element = resolveResult.getElement();
        return element == null ? this : new PsiImmediateClassType(element, resolveResult.getSubstitutor());
    }

    @NotNull
    public String getPresentableText() {
        String presentableText = PsiNameHelper.getPresentableText((PsiJavaCodeReferenceElement)this.myReference);
        PsiAnnotation[] annotations = this.getAnnotations();
        if (annotations.length == 0) {
            return presentableText;
        }
        StringBuilder sb = new StringBuilder();
        PsiNameHelper.appendAnnotations((StringBuilder)sb, (PsiAnnotation[])annotations, (boolean)false);
        sb.append(presentableText);
        return sb.toString();
    }

    @NotNull
    public String getCanonicalText(boolean annotated) {
        return this.getText(annotated);
    }

    @NotNull
    public String getInternalCanonicalText() {
        return this.getText(true);
    }

    private String getText(boolean annotated) {
        if (this.myReference instanceof PsiJavaCodeReferenceElementImpl) {
            PsiAnnotation[] annotations = this.getAnnotations();
            if (!annotated || annotations.length == 0) {
                annotations = null;
            }
            PsiJavaCodeReferenceElementImpl impl = (PsiJavaCodeReferenceElementImpl)this.myReference;
            return impl.getCanonicalText(annotated, annotations, impl.getContainingFile());
        }
        return this.myReference.getCanonicalText();
    }

    @NotNull
    public PsiJavaCodeReferenceElement getReference() {
        return this.myReference;
    }

    private static class DelegatingClassResolveResult
    implements PsiClassType.ClassResolveResult {
        private final JavaResolveResult myDelegate;

        private DelegatingClassResolveResult(@NotNull JavaResolveResult delegate) {
            this.myDelegate = delegate;
        }

        @NotNull
        public PsiSubstitutor getSubstitutor() {
            return this.myDelegate.getSubstitutor();
        }

        public boolean isValidResult() {
            return this.myDelegate.isValidResult();
        }

        public boolean isAccessible() {
            return this.myDelegate.isAccessible();
        }

        public boolean isStaticsScopeCorrect() {
            return this.myDelegate.isStaticsScopeCorrect();
        }

        public PsiElement getCurrentFileResolveScope() {
            return this.myDelegate.getCurrentFileResolveScope();
        }

        public boolean isPackagePrefixPackageReference() {
            return this.myDelegate.isPackagePrefixPackageReference();
        }

        public PsiClass getElement() {
            PsiElement element = this.myDelegate.getElement();
            return element instanceof PsiClass ? (PsiClass)element : null;
        }
    }
}

