/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.smartPointers;

import com.intellij.openapi.project.Project;
import com.intellij.psi.ClassTypePointerFactory;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.SmartTypePointer;
import com.intellij.psi.SmartTypePointerManager;
import com.intellij.psi.impl.PsiSubstitutorImpl;
import com.intellij.psi.impl.smartPointers.TypePointerBase;
import com.intellij.psi.impl.source.PsiClassReferenceType;
import com.intellij.psi.impl.source.PsiImmediateClassType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SmartTypePointerManagerImpl
extends SmartTypePointerManager {
    private static final SmartTypePointer NULL_POINTER = new SmartTypePointer(){

        public PsiType getType() {
            return null;
        }
    };
    private final SmartPointerManager myPsiPointerManager;
    private final Project myProject;

    public SmartTypePointerManagerImpl(SmartPointerManager psiPointerManager, Project project2) {
        this.myPsiPointerManager = psiPointerManager;
        this.myProject = project2;
    }

    @NotNull
    public SmartTypePointer createSmartTypePointer(@NotNull PsiType type) {
        SmartTypePointer pointer = (SmartTypePointer)type.accept((PsiTypeVisitor)new SmartTypeCreatingVisitor());
        return pointer != null ? pointer : NULL_POINTER;
    }

    @NotNull
    private SmartTypePointer createClassReferenceTypePointer(@NotNull PsiClassType classType) {
        for (ClassTypePointerFactory factory : (ClassTypePointerFactory[])ClassTypePointerFactory.EP_NAME.getExtensions()) {
            SmartTypePointer pointer = factory.createClassTypePointer(classType, this.myProject);
            if (pointer == null) continue;
            return pointer;
        }
        return new SimpleTypePointer((PsiType)classType);
    }

    private class SmartTypeCreatingVisitor
    extends PsiTypeVisitor<SmartTypePointer> {
        private SmartTypeCreatingVisitor() {
        }

        public SmartTypePointer visitPrimitiveType(PsiPrimitiveType primitiveType) {
            return new SimpleTypePointer((PsiType)primitiveType);
        }

        public SmartTypePointer visitArrayType(PsiArrayType arrayType) {
            SmartTypePointer componentTypePointer = (SmartTypePointer)arrayType.getComponentType().accept((PsiTypeVisitor)this);
            return componentTypePointer != null ? new ArrayTypePointer(arrayType, componentTypePointer) : null;
        }

        public SmartTypePointer visitWildcardType(PsiWildcardType wildcardType) {
            PsiType bound = wildcardType.getBound();
            SmartTypePointer boundPointer = bound == null ? null : (SmartTypePointer)bound.accept((PsiTypeVisitor)this);
            return new WildcardTypePointer(wildcardType, boundPointer);
        }

        public SmartTypePointer visitClassType(PsiClassType classType) {
            PsiClassType.ClassResolveResult resolveResult = classType.resolveGenerics();
            PsiClass aClass = resolveResult.getElement();
            if (aClass == null) {
                return SmartTypePointerManagerImpl.this.createClassReferenceTypePointer(classType);
            }
            if (classType instanceof PsiClassReferenceType) {
                classType = ((PsiClassReferenceType)classType).createImmediateCopy();
            }
            PsiSubstitutor substitutor = resolveResult.getSubstitutor();
            HashMap map = new HashMap();
            for (PsiTypeParameter typeParameter : PsiUtil.typeParametersIterable((PsiTypeParameterListOwner)aClass)) {
                PsiType substitutionResult = substitutor.substitute(typeParameter);
                if (substitutionResult == null) continue;
                SmartPsiElementPointer pointer = SmartTypePointerManagerImpl.this.myPsiPointerManager.createSmartPsiElementPointer((PsiElement)typeParameter);
                map.put((Object)pointer, substitutionResult.accept((PsiTypeVisitor)this));
            }
            return new ClassTypePointer(classType, SmartTypePointerManagerImpl.this.myPsiPointerManager.createSmartPsiElementPointer((PsiElement)aClass), (Map<SmartPsiElementPointer, SmartTypePointer>)map);
        }

        public SmartTypePointer visitDisjunctionType(PsiDisjunctionType disjunctionType) {
            return new DisjunctionTypePointer(disjunctionType);
        }
    }

    private class DisjunctionTypePointer
    extends TypePointerBase<PsiDisjunctionType> {
        private final List<SmartTypePointer> myPointers;

        private DisjunctionTypePointer(PsiDisjunctionType type) {
            super(type);
            this.myPointers = ContainerUtil.map((Collection)type.getDisjunctions(), (Function)new Function<PsiType, SmartTypePointer>(){

                public SmartTypePointer fun(PsiType psiType) {
                    return SmartTypePointerManagerImpl.this.createSmartTypePointer(psiType);
                }
            });
        }

        @Override
        protected PsiDisjunctionType calcType() {
            List types = ContainerUtil.map(this.myPointers, (Function)new NullableFunction<SmartTypePointer, PsiType>(){

                public PsiType fun(SmartTypePointer typePointer) {
                    return typePointer.getType();
                }
            });
            return new PsiDisjunctionType(types, PsiManager.getInstance((Project)SmartTypePointerManagerImpl.this.myProject));
        }
    }

    private static class ClassTypePointer
    extends TypePointerBase<PsiClassType> {
        private final SmartPsiElementPointer myClass;
        private final Map<SmartPsiElementPointer, SmartTypePointer> myMap;

        public ClassTypePointer(@NotNull PsiClassType type, @NotNull SmartPsiElementPointer aClass, @NotNull Map<SmartPsiElementPointer, SmartTypePointer> map) {
            super(type);
            this.myClass = aClass;
            this.myMap = map;
        }

        @Override
        protected PsiClassType calcType() {
            PsiElement classElement = this.myClass.getElement();
            if (!(classElement instanceof PsiClass)) {
                return null;
            }
            HashMap resurrected = new HashMap();
            Set<Map.Entry<SmartPsiElementPointer, SmartTypePointer>> set = this.myMap.entrySet();
            for (Map.Entry<SmartPsiElementPointer, SmartTypePointer> entry : set) {
                PsiElement element = entry.getKey().getElement();
                if (!(element instanceof PsiTypeParameter)) continue;
                SmartTypePointer typePointer = entry.getValue();
                resurrected.put((PsiTypeParameter)element, typePointer == null ? null : typePointer.getType());
            }
            for (PsiTypeParameter typeParameter : PsiUtil.typeParametersIterable((PsiTypeParameterListOwner)((PsiClass)classElement))) {
                if (resurrected.containsKey(typeParameter)) continue;
                resurrected.put(typeParameter, null);
            }
            PsiSubstitutor resurrectedSubstitutor = PsiSubstitutorImpl.createSubstitutor((Map<PsiTypeParameter, PsiType>)resurrected);
            return new PsiImmediateClassType((PsiClass)classElement, resurrectedSubstitutor);
        }
    }

    private static class WildcardTypePointer
    extends TypePointerBase<PsiWildcardType> {
        private final PsiManager myManager;
        private final SmartTypePointer myBoundPointer;
        private final boolean myIsExtending;

        public WildcardTypePointer(@NotNull PsiWildcardType type, @Nullable SmartTypePointer boundPointer) {
            super(type);
            this.myManager = type.getManager();
            this.myBoundPointer = boundPointer;
            this.myIsExtending = type.isExtends();
        }

        @Override
        protected PsiWildcardType calcType() {
            if (this.myBoundPointer == null) {
                return PsiWildcardType.createUnbounded((PsiManager)this.myManager);
            }
            PsiType type = this.myBoundPointer.getType();
            assert (type != null) : this.myBoundPointer;
            if (this.myIsExtending) {
                return PsiWildcardType.createExtends((PsiManager)this.myManager, (PsiType)type);
            }
            return PsiWildcardType.createSuper((PsiManager)this.myManager, (PsiType)type);
        }
    }

    private static class ArrayTypePointer
    extends TypePointerBase<PsiArrayType> {
        private final SmartTypePointer myComponentTypePointer;

        public ArrayTypePointer(@NotNull PsiArrayType type, @NotNull SmartTypePointer componentTypePointer) {
            super(type);
            this.myComponentTypePointer = componentTypePointer;
        }

        @Override
        @Nullable
        protected PsiArrayType calcType() {
            PsiType type = this.myComponentTypePointer.getType();
            return type == null ? null : new PsiArrayType(type);
        }
    }

    private static class SimpleTypePointer
    implements SmartTypePointer {
        private final PsiType myType;

        private SimpleTypePointer(@NotNull PsiType type) {
            this.myType = type;
        }

        public PsiType getType() {
            return this.myType;
        }
    }
}

