/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.smartPointers;

import com.intellij.lang.LanguageUtil;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiAnchor;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.impl.FreeThreadedFileViewProvider;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.smartPointers.AnchorTypeInfo;
import com.intellij.psi.impl.smartPointers.ClsElementInfo;
import com.intellij.psi.impl.smartPointers.DirElementInfo;
import com.intellij.psi.impl.smartPointers.FileElementInfo;
import com.intellij.psi.impl.smartPointers.HardElementInfo;
import com.intellij.psi.impl.smartPointers.InjectedSelfElementInfo;
import com.intellij.psi.impl.smartPointers.SelfElementInfo;
import com.intellij.psi.impl.smartPointers.SmartPointerElementInfo;
import com.intellij.psi.impl.smartPointers.SmartPointerElementInfoFactory;
import com.intellij.psi.impl.smartPointers.SmartPointerEx;
import com.intellij.psi.impl.source.tree.ForeignLeafPsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.reference.SoftReference;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class SmartPsiElementPointerImpl<E extends PsiElement>
implements SmartPointerEx<E> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.smartPointers.SmartPsiElementPointerImpl");
    private Reference<E> myElement;
    private final SmartPointerElementInfo myElementInfo;
    private final Class<? extends PsiElement> myElementClass;
    private byte myReferenceCount = 1;

    SmartPsiElementPointerImpl(@NotNull Project project2, @NotNull E element, @Nullable PsiFile containingFile) {
        this(element, SmartPsiElementPointerImpl.createElementInfo(project2, element, containingFile), element.getClass());
    }

    SmartPsiElementPointerImpl(@NotNull E element, @NotNull SmartPointerElementInfo elementInfo, @NotNull Class<? extends PsiElement> elementClass) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        this.myElementClass = elementClass;
        this.myElementInfo = elementInfo;
        this.cacheElement(element);
    }

    public boolean equals(Object obj) {
        return obj instanceof SmartPsiElementPointer && SmartPsiElementPointerImpl.pointsToTheSameElementAs(this, (SmartPsiElementPointer)obj);
    }

    public int hashCode() {
        return this.myElementInfo.elementHashCode();
    }

    @NotNull
    public Project getProject() {
        return this.myElementInfo.getProject();
    }

    @Nullable
    public E getElement() {
        E element = this.getCachedElement();
        if (element == null || !element.isValid()) {
            element = this.doRestoreElement();
            this.cacheElement(element);
        }
        return element;
    }

    @Nullable
    E doRestoreElement() {
        PsiElement element = this.myElementInfo.restoreElement();
        if (!(element == null || element.getClass().equals(this.myElementClass) && element.isValid())) {
            return null;
        }
        return (E)element;
    }

    void cacheElement(@Nullable E element) {
        this.myElement = element == null ? null : (((PsiManagerEx)PsiManager.getInstance((Project)this.getProject())).isBatchFilesProcessingMode() ? new WeakReference<E>(element) : new java.lang.ref.SoftReference<E>(element));
    }

    public E getCachedElement() {
        return (E)((PsiElement)SoftReference.dereference(this.myElement));
    }

    public PsiFile getContainingFile() {
        PsiFile file2 = this.getElementInfo().restoreFile();
        if (file2 != null) {
            return file2;
        }
        Document doc = this.myElementInfo.getDocumentToSynchronize();
        if (doc == null) {
            E resolved = this.getElement();
            return resolved == null ? null : resolved.getContainingFile();
        }
        return PsiDocumentManager.getInstance((Project)this.getProject()).getPsiFile(doc);
    }

    public VirtualFile getVirtualFile() {
        return this.myElementInfo.getVirtualFile();
    }

    public Segment getRange() {
        return this.myElementInfo.getRange();
    }

    @Nullable
    public Segment getPsiRange() {
        return this.myElementInfo.getPsiRange();
    }

    @NotNull
    private static <E extends PsiElement> SmartPointerElementInfo createElementInfo(@NotNull Project project2, @NotNull E element, PsiFile containingFile) {
        SmartPointerElementInfo elementInfo = SmartPsiElementPointerImpl.doCreateElementInfo(project2, element, containingFile);
        if (ApplicationManager.getApplication().isUnitTestMode() && !element.equals(elementInfo.restoreElement())) {
            LOG.error("Cannot restore " + element + " of " + element.getClass() + " from " + elementInfo);
        }
        return elementInfo;
    }

    @NotNull
    private static <E extends PsiElement> SmartPointerElementInfo doCreateElementInfo(@NotNull Project project2, @NotNull E element, PsiFile containingFile) {
        if (element instanceof PsiDirectory) {
            return new DirElementInfo((PsiDirectory)element);
        }
        if (element instanceof PsiCompiledElement || containingFile == null || !containingFile.isPhysical() || !element.isPhysical()) {
            if (element instanceof StubBasedPsiElement && element instanceof PsiCompiledElement) {
                if (element instanceof PsiFile) {
                    return new FileElementInfo((PsiFile)element);
                }
                PsiAnchor.StubIndexReference stubReference = PsiAnchor.createStubReference(element, containingFile);
                if (stubReference != null) {
                    return new ClsElementInfo(stubReference);
                }
            }
            return new HardElementInfo(project2, element);
        }
        FileViewProvider viewProvider = containingFile.getViewProvider();
        if (viewProvider instanceof FreeThreadedFileViewProvider) {
            PsiLanguageInjectionHost hostContext = InjectedLanguageManager.getInstance((Project)containingFile.getProject()).getInjectionHost((PsiElement)containingFile);
            TextRange elementRange = element.getTextRange();
            if (hostContext != null && elementRange != null) {
                SmartPsiElementPointer hostPointer = SmartPointerManager.getInstance((Project)project2).createSmartPsiElementPointer((PsiElement)hostContext);
                return new InjectedSelfElementInfo(project2, element, elementRange, containingFile, (SmartPsiElementPointer<PsiLanguageInjectionHost>)hostPointer);
            }
        }
        for (PsiLanguageInjectionHost factory : (PsiLanguageInjectionHost)Extensions.getExtensions(SmartPointerElementInfoFactory.EP_NAME)) {
            SmartPointerElementInfo result = factory.createElementInfo(element, containingFile);
            if (result == null) continue;
            return result;
        }
        if (element instanceof PsiFile) {
            return new FileElementInfo((PsiFile)element);
        }
        TextRange elementRange = element.getTextRange();
        if (elementRange == null) {
            return new HardElementInfo(project2, element);
        }
        if (elementRange.isEmpty() && PsiTreeUtil.findChildOfType(element, ForeignLeafPsiElement.class) != null) {
            return new HardElementInfo(project2, element);
        }
        ProperTextRange proper = ProperTextRange.create((Segment)elementRange);
        return new SelfElementInfo(project2, proper, AnchorTypeInfo.obtainInfo(element, LanguageUtil.getRootLanguage(element)), containingFile, false);
    }

    @NotNull
    SmartPointerElementInfo getElementInfo() {
        return this.myElementInfo;
    }

    static boolean pointsToTheSameElementAs(@NotNull SmartPsiElementPointer pointer1, @NotNull SmartPsiElementPointer pointer2) {
        if (pointer1 == pointer2) {
            return true;
        }
        if (pointer1 instanceof SmartPsiElementPointerImpl && pointer2 instanceof SmartPsiElementPointerImpl) {
            SmartPointerElementInfo elementInfo2;
            SmartPsiElementPointerImpl impl1 = (SmartPsiElementPointerImpl)pointer1;
            SmartPsiElementPointerImpl impl2 = (SmartPsiElementPointerImpl)pointer2;
            SmartPointerElementInfo elementInfo1 = impl1.getElementInfo();
            if (!elementInfo1.pointsToTheSameElementAs(elementInfo2 = impl2.getElementInfo())) {
                return false;
            }
            Object cachedElement1 = impl1.getCachedElement();
            Object cachedElement2 = impl2.getCachedElement();
            return cachedElement1 == null || cachedElement2 == null || Comparing.equal(cachedElement1, cachedElement2);
        }
        return Comparing.equal((Object)pointer1.getElement(), (Object)pointer2.getElement());
    }

    synchronized int incrementAndGetReferenceCount(int delta) {
        if (this.myReferenceCount == 127) {
            return 127;
        }
        if (this.myReferenceCount == 0) {
            return 0;
        }
        this.myReferenceCount = (byte)(this.myReferenceCount + delta);
        return this.myReferenceCount;
    }

    public String toString() {
        return this.myElementInfo.toString();
    }
}

