/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.smartPointers;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.ClassTypePointerFactory;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.SmartTypePointer;
import com.intellij.psi.impl.smartPointers.TypePointerBase;
import com.intellij.psi.impl.source.PsiClassReferenceType;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiClassReferenceTypePointerFactory
implements ClassTypePointerFactory {
    private static final Logger LOG = Logger.getInstance(PsiClassReferenceTypePointerFactory.class);

    @Nullable
    public SmartTypePointer createClassTypePointer(@NotNull PsiClassType classType, @NotNull Project project2) {
        if (classType instanceof PsiClassReferenceType) {
            return new ClassReferenceTypePointer((PsiClassReferenceType)classType, project2);
        }
        return null;
    }

    private static class ClassReferenceTypePointer
    extends TypePointerBase<PsiClassReferenceType> {
        private final SmartPsiElementPointer mySmartPsiElementPointer;
        private final String myReferenceText;
        private final Project myProject;

        ClassReferenceTypePointer(@NotNull PsiClassReferenceType type, Project project2) {
            super(type);
            this.myProject = project2;
            PsiJavaCodeReferenceElement reference = type.getReference();
            this.mySmartPsiElementPointer = SmartPointerManager.getInstance((Project)this.myProject).createSmartPsiElementPointer((PsiElement)reference);
            this.myReferenceText = reference.getText();
        }

        @Override
        protected PsiClassReferenceType calcType() {
            PsiClassReferenceType myType = null;
            PsiJavaCodeReferenceElement referenceElement = (PsiJavaCodeReferenceElement)this.mySmartPsiElementPointer.getElement();
            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)this.myProject).getElementFactory();
            if (referenceElement != null) {
                myType = (PsiClassReferenceType)factory.createType(referenceElement);
            } else {
                try {
                    myType = (PsiClassReferenceType)factory.createTypeFromText(this.myReferenceText, null);
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
            }
            return myType;
        }
    }
}

