/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.smartPointers;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.smartPointers.SmartPointerElementInfo;
import com.intellij.psi.util.PsiUtilCore;
import org.jetbrains.annotations.NotNull;

class HardElementInfo
extends SmartPointerElementInfo {
    @NotNull
    private final PsiElement myElement;
    @NotNull
    private final Project myProject;

    public HardElementInfo(@NotNull Project project2, @NotNull PsiElement element) {
        this.myElement = element;
        this.myProject = project2;
    }

    @Override
    public PsiElement restoreElement() {
        return this.myElement;
    }

    @Override
    public PsiFile restoreFile() {
        return this.myElement.getContainingFile();
    }

    @Override
    public int elementHashCode() {
        return this.myElement.hashCode();
    }

    @Override
    public boolean pointsToTheSameElementAs(@NotNull SmartPointerElementInfo other) {
        return Comparing.equal((Object)this.myElement, (Object)other.restoreElement());
    }

    @Override
    public VirtualFile getVirtualFile() {
        return PsiUtilCore.getVirtualFile((PsiElement)this.myElement);
    }

    @Override
    public Segment getRange() {
        return this.myElement.getTextRange();
    }

    @Override
    public Segment getPsiRange() {
        return this.getRange();
    }

    @Override
    @NotNull
    public Project getProject() {
        return this.myProject;
    }

    public String toString() {
        return "hard{" + this.myElement + " of " + this.myElement.getClass() + "}";
    }
}

