/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.lang.spi.SPILanguage;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.ClassUtil;
import com.intellij.util.Processor;
import org.jetbrains.annotations.NotNull;

public class SPIReferencesSearcher
extends QueryExecutorBase<PsiReference, ReferencesSearch.SearchParameters> {
    public void processQuery(final @NotNull ReferencesSearch.SearchParameters p, final @NotNull Processor<PsiReference> consumer) {
        block7: {
            String[] filenames;
            PsiElement element;
            SearchScope scope;
            block6: {
                PsiFile[] files;
                scope = (SearchScope)ApplicationManager.getApplication().runReadAction((Computable)new Computable<SearchScope>(){

                    public SearchScope compute() {
                        return p.getEffectiveSearchScope();
                    }
                });
                if (!(scope instanceof GlobalSearchScope)) {
                    return;
                }
                element = p.getElementToSearch();
                if (!(element instanceof PsiClass)) break block6;
                final PsiClass aClass = (PsiClass)element;
                final String jvmClassName = (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

                    public String compute() {
                        return ClassUtil.getJVMClassName((PsiClass)aClass);
                    }
                });
                if (jvmClassName == null) {
                    return;
                }
                for (PsiFile file2 : files = (PsiFile[])ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiFile[]>(){

                    public PsiFile[] compute() {
                        return FilenameIndex.getFilesByName(aClass.getProject(), jvmClassName, (GlobalSearchScope)scope);
                    }
                })) {
                    PsiReference reference;
                    if (file2.getLanguage() != SPILanguage.INSTANCE || (reference = file2.getReference()) == null) continue;
                    ApplicationManager.getApplication().runReadAction(new Runnable(){

                        @Override
                        public void run() {
                            consumer.process((Object)reference);
                        }
                    });
                }
                break block7;
            }
            if (!(element instanceof PsiPackage)) break block7;
            String qualifiedName = ((PsiPackage)element).getQualifiedName();
            final Project project2 = element.getProject();
            for (final String filename : filenames = (String[])ApplicationManager.getApplication().runReadAction((Computable)new Computable<String[]>(){

                public String[] compute() {
                    return FilenameIndex.getAllFilenames(project2);
                }
            })) {
                PsiFile[] files;
                if (!filename.startsWith(qualifiedName + ".")) continue;
                for (PsiFile file3 : files = (PsiFile[])ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiFile[]>(){

                    public PsiFile[] compute() {
                        return FilenameIndex.getFilesByName(project2, filename, (GlobalSearchScope)scope);
                    }
                })) {
                    PsiReference[] references;
                    if (file3.getLanguage() != SPILanguage.INSTANCE) continue;
                    for (final PsiReference reference : references = file3.getReferences()) {
                        if (!reference.getCanonicalText().equals(qualifiedName)) continue;
                        ApplicationManager.getApplication().runReadAction(new Runnable(){

                            @Override
                            public void run() {
                                consumer.process((Object)reference);
                            }
                        });
                    }
                }
            }
        }
    }
}

