/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadActionProcessor;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import com.intellij.util.QueryExecutor;
import org.jetbrains.annotations.NotNull;

public class PsiAnnotationMethodReferencesSearcher
implements QueryExecutor<PsiReference, ReferencesSearch.SearchParameters> {
    public boolean execute(final @NotNull ReferencesSearch.SearchParameters p, @NotNull Processor<PsiReference> consumer) {
        final PsiElement refElement = p.getElementToSearch();
        boolean isAnnotation = (Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

            public Boolean compute() {
                return PsiUtil.isAnnotationMethod((PsiElement)refElement);
            }
        });
        if (isAnnotation) {
            final PsiMethod method = (PsiMethod)refElement;
            PsiClass containingClass = (PsiClass)ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiClass>(){

                public PsiClass compute() {
                    boolean isValueMethod = "value".equals(method.getName()) && method.getParameterList().getParametersCount() == 0;
                    return isValueMethod ? method.getContainingClass() : null;
                }
            });
            if (containingClass != null) {
                SearchScope scope = (SearchScope)ApplicationManager.getApplication().runReadAction((Computable)new Computable<SearchScope>(){

                    public SearchScope compute() {
                        return p.getEffectiveSearchScope();
                    }
                });
                Query query = ReferencesSearch.search((PsiElement)containingClass, (SearchScope)scope, (boolean)p.isIgnoreAccessScope());
                return query.forEach(PsiAnnotationMethodReferencesSearcher.createImplicitDefaultAnnotationMethodConsumer(consumer));
            }
        }
        return true;
    }

    public static ReadActionProcessor<PsiReference> createImplicitDefaultAnnotationMethodConsumer(final Processor<PsiReference> consumer) {
        return new ReadActionProcessor<PsiReference>(){

            public boolean processInReadAction(PsiReference reference) {
                PsiReference t;
                PsiNameValuePair[] members;
                PsiJavaCodeReferenceElement javaReference;
                return !(reference instanceof PsiJavaCodeReferenceElement) || !((javaReference = (PsiJavaCodeReferenceElement)reference).getParent() instanceof PsiAnnotation) || (members = ((PsiAnnotation)javaReference.getParent()).getParameterList().getAttributes()).length != 1 || members[0].getNameIdentifier() != null || (t = members[0].getReference()) == null || consumer.process((Object)t);
            }
        };
    }
}

