/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchRequestCollector;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.util.Processor;
import org.jetbrains.annotations.NotNull;

public class NonPhysicalReferenceSearcher
extends QueryExecutorBase<PsiReference, ReferencesSearch.SearchParameters> {
    public NonPhysicalReferenceSearcher() {
        super(true);
    }

    public void processQuery(@NotNull ReferencesSearch.SearchParameters queryParameters, @NotNull Processor<PsiReference> consumer) {
        LocalSearchScope currentScope;
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        SearchScope scope = queryParameters.getScopeDeterminedByUser();
        PsiElement element = queryParameters.getElementToSearch();
        PsiFile containingFile = element.getContainingFile();
        if (!(scope instanceof GlobalSearchScope) && !NonPhysicalReferenceSearcher.isApplicableTo(containingFile)) {
            return;
        }
        if (scope instanceof LocalSearchScope) {
            if (queryParameters.isIgnoreAccessScope()) {
                return;
            }
            currentScope = (LocalSearchScope)scope;
        } else {
            currentScope = null;
        }
        Project project2 = element.getProject();
        if (!project2.isInitialized()) {
            return;
        }
        PsiManager psiManager = PsiManager.getInstance((Project)project2);
        for (VirtualFile virtualFile : FileEditorManager.getInstance((Project)project2).getOpenFiles()) {
            PsiFile file2;
            if (virtualFile.getFileType().isBinary() || !NonPhysicalReferenceSearcher.isApplicableTo(file2 = psiManager.findFile(virtualFile))) continue;
            LocalSearchScope fileScope = new LocalSearchScope((PsiElement)file2);
            LocalSearchScope searchScope = currentScope == null ? fileScope : fileScope.intersectWith(currentScope);
            ReferencesSearch.searchOptimized((PsiElement)element, (SearchScope)searchScope, (boolean)true, (SearchRequestCollector)queryParameters.getOptimizer(), consumer);
        }
    }

    private static boolean isApplicableTo(PsiFile file2) {
        if (file2 == null) {
            return false;
        }
        return !file2.getViewProvider().isPhysical() && !(file2 instanceof PsiCodeFragment) || ScratchFileService.getInstance().getRootType(file2.getVirtualFile()) != null;
    }
}

