/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.lang.java.JavaParserDefinition;
import com.intellij.lexer.Lexer;
import com.intellij.psi.JavaDocTokenType;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.ServerPageFile;
import com.intellij.psi.impl.search.IndexPatternBuilder;
import com.intellij.psi.impl.source.tree.StdTokenSets;
import com.intellij.psi.jsp.JspFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.xml.XmlTokenType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaIndexPatternBuilder
implements IndexPatternBuilder {
    public static final TokenSet XML_DATA_CHARS = TokenSet.create((IElementType[])new IElementType[]{XmlTokenType.XML_DATA_CHARACTERS});
    public static final TokenSet XML_COMMENT_BIT_SET = TokenSet.create((IElementType[])new IElementType[]{XmlTokenType.XML_COMMENT_CHARACTERS});

    @Override
    @Nullable
    public Lexer getIndexingLexer(@NotNull PsiFile file2) {
        if (file2 instanceof PsiJavaFile && !(file2 instanceof JspFile)) {
            return JavaParserDefinition.createLexer(((PsiJavaFile)file2).getLanguageLevel());
        }
        return null;
    }

    @Override
    @Nullable
    public TokenSet getCommentTokenSet(@NotNull PsiFile file2) {
        if (file2 instanceof PsiJavaFile && !(file2 instanceof ServerPageFile)) {
            return TokenSet.orSet((TokenSet[])new TokenSet[]{StdTokenSets.COMMENT_BIT_SET, XML_COMMENT_BIT_SET, JavaDocTokenType.ALL_JAVADOC_TOKENS, XML_DATA_CHARS});
        }
        return null;
    }

    @Override
    public int getCommentStartDelta(IElementType tokenType) {
        return 0;
    }

    @Override
    public int getCommentEndDelta(IElementType tokenType) {
        return tokenType == JavaTokenType.C_STYLE_COMMENT ? "*/".length() : 0;
    }
}

