/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.openapi.application.ReadActionProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiAnchor;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiBundle;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchScopeUtil;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AllClassesSearch;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.search.searches.DirectClassInheritorsSearch;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Stack;
import gnu.trove.THashSet;
import org.jetbrains.annotations.NotNull;

public class JavaClassInheritorsSearcher
extends QueryExecutorBase<PsiClass, ClassInheritorsSearch.SearchParameters> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.search.JavaClassInheritorsSearcher");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processQuery(@NotNull ClassInheritorsSearch.SearchParameters parameters, @NotNull Processor<PsiClass> consumer) {
        final PsiClass baseClass = parameters.getClassToProcess();
        SearchScope searchScope = parameters.getScope();
        LOG.assertTrue(searchScope != null);
        ProgressIndicator progress = ProgressIndicatorProvider.getGlobalProgressIndicator();
        if (progress != null) {
            progress.pushState();
            String className = (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

                public String compute() {
                    return baseClass.getName();
                }
            });
            progress.setText(className != null ? PsiBundle.message((String)"psi.search.inheritors.of.class.progress", (Object[])new Object[]{className}) : PsiBundle.message((String)"psi.search.inheritors.progress", (Object[])new Object[0]));
        }
        try {
            JavaClassInheritorsSearcher.processInheritors(consumer, baseClass, searchScope, parameters);
        }
        finally {
            if (progress != null) {
                progress.popState();
            }
        }
    }

    private static void processInheritors(final @NotNull Processor<PsiClass> consumer, final @NotNull PsiClass baseClass, final @NotNull SearchScope searchScope, final @NotNull ClassInheritorsSearch.SearchParameters parameters) {
        if (baseClass instanceof PsiAnonymousClass || JavaClassInheritorsSearcher.isFinal(baseClass)) {
            return;
        }
        Project project2 = PsiUtilCore.getProjectInReadAction((PsiElement)baseClass);
        if (JavaClassInheritorsSearcher.isJavaLangObject(baseClass)) {
            AllClassesSearch.search((SearchScope)searchScope, (Project)project2, (Condition)parameters.getNameCondition()).forEach((Processor)new Processor<PsiClass>(){

                public boolean process(PsiClass aClass) {
                    ProgressManager.checkCanceled();
                    return JavaClassInheritorsSearcher.isJavaLangObject(aClass) || consumer.process((Object)aClass);
                }
            });
            return;
        }
        final Ref currentBase = Ref.create(null);
        final Stack stack = new Stack();
        THashSet processed2 = ContainerUtil.newTroveSet();
        ReadActionProcessor<PsiClass> processor2 = new ReadActionProcessor<PsiClass>(){

            public boolean processInReadAction(PsiClass candidate) {
                ProgressManager.checkCanceled();
                if ((parameters.isCheckInheritance() || parameters.isCheckDeep() && !(candidate instanceof PsiAnonymousClass)) && !candidate.isInheritor((PsiClass)currentBase.get(), false)) {
                    return true;
                }
                if (PsiSearchScopeUtil.isInScope((SearchScope)searchScope, (PsiElement)candidate)) {
                    if (candidate instanceof PsiAnonymousClass) {
                        return consumer.process((Object)candidate);
                    }
                    String name = candidate.getName();
                    if (name != null && parameters.getNameCondition().value((Object)name) && !consumer.process((Object)candidate)) {
                        return false;
                    }
                }
                if (parameters.isCheckDeep() && !(candidate instanceof PsiAnonymousClass) && !JavaClassInheritorsSearcher.isFinal(candidate)) {
                    stack.push((Object)PsiAnchor.create((PsiElement)candidate));
                }
                return true;
            }
        };
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                stack.push((Object)PsiAnchor.create((PsiElement)baseClass));
            }
        });
        GlobalSearchScope projectScope = GlobalSearchScope.allScope((Project)project2);
        while (!stack.isEmpty()) {
            PsiClass psiClass;
            ProgressManager.checkCanceled();
            final PsiAnchor anchor = (PsiAnchor)stack.pop();
            if (!processed2.add(anchor) || (psiClass = (PsiClass)ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiClass>(){

                public PsiClass compute() {
                    return (PsiClass)anchor.retrieve();
                }
            })) == null) continue;
            currentBase.set((Object)psiClass);
            if (DirectClassInheritorsSearch.search((PsiClass)psiClass, (SearchScope)projectScope, (boolean)parameters.isIncludeAnonymous(), (boolean)false).forEach((Processor)processor2)) continue;
            return;
        }
    }

    private static boolean isJavaLangObject(final @NotNull PsiClass baseClass) {
        return (Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

            public Boolean compute() {
                return baseClass.isValid() && "java.lang.Object".equals(baseClass.getQualifiedName());
            }
        });
    }

    private static boolean isFinal(final @NotNull PsiClass baseClass) {
        return (Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

            public Boolean compute() {
                return baseClass.hasModifierProperty("final");
            }
        });
    }
}

