/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.impl.java.stubs.index.JavaAnnotationIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.searches.AnnotatedPackagesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Processor;
import com.intellij.util.QueryExecutor;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class AnnotatedPackagesSearcher
implements QueryExecutor<PsiPackage, AnnotatedPackagesSearch.Parameters> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.search.AnnotatedPackagesSearcher");

    public boolean execute(@NotNull AnnotatedPackagesSearch.Parameters p, final @NotNull Processor<PsiPackage> consumer) {
        final PsiClass annClass = p.getAnnotationClass();
        assert (annClass.isAnnotationType()) : "Annotation type should be passed to annotated packages search";
        final String annotationFQN = (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

            public String compute() {
                return annClass.getQualifiedName();
            }
        });
        assert (annotationFQN != null);
        final PsiManager psiManager = (PsiManager)ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiManager>(){

            public PsiManager compute() {
                return annClass.getManager();
            }
        });
        final GlobalSearchScope useScope = (GlobalSearchScope)p.getScope();
        String annotationShortName = (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

            public String compute() {
                return annClass.getName();
            }
        });
        assert (annotationShortName != null);
        Collection<PsiAnnotation> annotations = JavaAnnotationIndex.getInstance().get(annotationShortName, psiManager.getProject(), useScope);
        for (final PsiAnnotation annotation : annotations) {
            boolean accepted = (Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

                public Boolean compute() {
                    PsiClass candidate;
                    PsiModifierList modlist = (PsiModifierList)annotation.getParent();
                    PsiElement owner = modlist.getParent();
                    if (owner instanceof PsiClass && "package-info".equals((candidate = (PsiClass)owner).getName())) {
                        String qname;
                        LOG.assertTrue(candidate.isValid());
                        PsiJavaCodeReferenceElement ref = annotation.getNameReferenceElement();
                        if (ref != null && psiManager.areElementsEquivalent(ref.resolve(), (PsiElement)annClass) && useScope.contains(candidate.getContainingFile().getVirtualFile()) && (qname = candidate.getQualifiedName()) != null && !consumer.process((Object)JavaPsiFacade.getInstance((Project)psiManager.getProject()).findPackage(qname.substring(0, qname.lastIndexOf(46))))) {
                            return false;
                        }
                    }
                    return true;
                }
            });
            if (accepted) continue;
            return false;
        }
        PsiSearchHelper helper = PsiSearchHelper.SERVICE.getInstance((Project)psiManager.getProject());
        PackageInfoFilesOnly infoFilesFilter = new PackageInfoFilesOnly();
        GlobalSearchScope infoFiles = useScope.intersectWith((GlobalSearchScope)infoFilesFilter);
        final boolean[] wantMore = new boolean[]{true};
        helper.processAllFilesWithWord(annotationShortName, infoFiles, (Processor)new Processor<PsiFile>(){

            public boolean process(PsiFile psiFile) {
                PsiPackageStatement stmt = (PsiPackageStatement)PsiTreeUtil.getChildOfType((PsiElement)psiFile, PsiPackageStatement.class);
                if (stmt == null) {
                    return true;
                }
                PsiModifierList annotations = stmt.getAnnotationList();
                if (annotations == null) {
                    return true;
                }
                PsiAnnotation ann = annotations.findAnnotation(annotationFQN);
                if (ann == null) {
                    return true;
                }
                PsiJavaCodeReferenceElement ref = ann.getNameReferenceElement();
                if (ref == null) {
                    return true;
                }
                if (!psiManager.areElementsEquivalent(ref.resolve(), (PsiElement)annClass)) {
                    return true;
                }
                wantMore[0] = consumer.process((Object)JavaPsiFacade.getInstance((Project)psiManager.getProject()).findPackage(stmt.getPackageName()));
                return wantMore[0];
            }
        }, true);
        return wantMore[0];
    }

    private static class PackageInfoFilesOnly
    extends GlobalSearchScope {
        private PackageInfoFilesOnly() {
        }

        public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
            return 0;
        }

        public boolean contains(@NotNull VirtualFile file2) {
            return "package-info.java".equals(file2.getName());
        }

        public boolean isSearchInLibraries() {
            return false;
        }

        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            return true;
        }
    }
}

