/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.impl.search.MethodUsagesSearcher;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AllClassesSearch;
import com.intellij.util.Consumer;
import com.intellij.util.Processor;
import com.intellij.util.QueryExecutor;
import com.intellij.util.indexing.IdFilter;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class AllClassesSearchExecutor
implements QueryExecutor<PsiClass, AllClassesSearch.SearchParameters> {
    public boolean execute(@NotNull AllClassesSearch.SearchParameters queryParameters, @NotNull Processor<PsiClass> consumer) {
        PsiElement[] scopeRoots;
        SearchScope scope = queryParameters.getScope();
        if (scope instanceof GlobalSearchScope) {
            return AllClassesSearchExecutor.processAllClassesInGlobalScope((GlobalSearchScope)scope, queryParameters, consumer);
        }
        for (PsiElement scopeRoot : scopeRoots = ((LocalSearchScope)scope).getScope()) {
            if (AllClassesSearchExecutor.processScopeRootForAllClasses(scopeRoot, consumer)) continue;
            return false;
        }
        return true;
    }

    private static boolean processAllClassesInGlobalScope(@NotNull GlobalSearchScope scope, final @NotNull AllClassesSearch.SearchParameters parameters, @NotNull Processor<PsiClass> processor2) {
        THashSet names = new THashSet(10000);
        AllClassesSearchExecutor.processClassNames(parameters.getProject(), scope, new Consumer<String>((Set)names){
            final /* synthetic */ Set val$names;
            {
                this.val$names = set;
            }

            public void consume(String s) {
                if (parameters.nameMatches(s)) {
                    this.val$names.add(s);
                }
            }
        });
        ArrayList<String> sorted = new ArrayList<String>((Collection<String>)names);
        Collections.sort(sorted, String.CASE_INSENSITIVE_ORDER);
        return AllClassesSearchExecutor.processClassesByNames(parameters.getProject(), scope, sorted, processor2);
    }

    public static boolean processClassesByNames(Project project2, final GlobalSearchScope scope, Collection<String> names, Processor<PsiClass> processor2) {
        final PsiShortNamesCache cache = PsiShortNamesCache.getInstance((Project)project2);
        for (final String name : names) {
            PsiClass[] classes;
            ProgressIndicatorProvider.checkCanceled();
            for (PsiClass psiClass : classes = MethodUsagesSearcher.resolveInReadAction(project2, new Computable<PsiClass[]>(){

                public PsiClass[] compute() {
                    return cache.getClassesByName(name, scope);
                }
            })) {
                ProgressIndicatorProvider.checkCanceled();
                if (processor2.process((Object)psiClass)) continue;
                return false;
            }
        }
        return true;
    }

    public static Project processClassNames(final Project project2, final GlobalSearchScope scope, final Consumer<String> consumer) {
        final ProgressIndicator indicator = ProgressIndicatorProvider.getGlobalProgressIndicator();
        MethodUsagesSearcher.resolveInReadAction(project2, new Computable<Void>(){

            public Void compute() {
                PsiShortNamesCache.getInstance((Project)project2).processAllClassNames((Processor)new Processor<String>(){
                    int i = 0;

                    public boolean process(String s) {
                        if (indicator != null && this.i++ % 512 == 0) {
                            indicator.checkCanceled();
                        }
                        consumer.consume((Object)s);
                        return true;
                    }
                }, scope, IdFilter.getProjectIdFilter((Project)project2, (boolean)true));
                return null;
            }
        });
        if (indicator != null) {
            indicator.checkCanceled();
        }
        return project2;
    }

    private static boolean processScopeRootForAllClasses(final @NotNull PsiElement scopeRoot, final @NotNull Processor<PsiClass> processor2) {
        final boolean[] stopped = new boolean[]{false};
        Object visitor = scopeRoot instanceof PsiCompiledElement ? new JavaRecursiveElementVisitor(){

            public void visitElement(PsiElement element) {
                if (!stopped[0]) {
                    super.visitElement(element);
                }
            }

            public void visitClass(PsiClass aClass) {
                stopped[0] = !processor2.process((Object)aClass);
                super.visitClass(aClass);
            }
        } : new JavaRecursiveElementWalkingVisitor(){

            public void visitElement(PsiElement element) {
                if (!stopped[0]) {
                    super.visitElement(element);
                }
            }

            public void visitClass(PsiClass aClass) {
                stopped[0] = !processor2.process((Object)aClass);
                super.visitClass(aClass);
            }
        };
        ApplicationManager.getApplication().runReadAction(new Runnable((JavaElementVisitor)visitor){
            final /* synthetic */ JavaElementVisitor val$visitor;
            {
                this.val$visitor = javaElementVisitor;
            }

            @Override
            public void run() {
                scopeRoot.accept((PsiElementVisitor)this.val$visitor);
            }
        });
        return !stopped[0];
    }
}

