/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.migration;

import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElementFinder;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.impl.migration.PsiMigrationImpl;
import com.intellij.psi.impl.migration.PsiMigrationManager;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class MigrationElementFinder
extends PsiElementFinder
implements DumbAware {
    private final Project myProject;

    public MigrationElementFinder(Project project2) {
        this.myProject = project2;
    }

    public PsiClass findClass(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope) {
        PsiMigrationImpl migration = PsiMigrationManager.getInstance(this.myProject).getCurrentMigration();
        if (migration != null) {
            return migration.getMigrationClass(qualifiedName);
        }
        return null;
    }

    @NotNull
    public PsiClass[] findClasses(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope) {
        PsiClass migrationClass;
        PsiMigrationImpl migration = PsiMigrationManager.getInstance(this.myProject).getCurrentMigration();
        if (migration != null && (migrationClass = migration.getMigrationClass(qualifiedName)) != null) {
            return new PsiClass[]{migrationClass};
        }
        return PsiClass.EMPTY_ARRAY;
    }

    @NotNull
    public PsiClass[] getClasses(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope) {
        PsiMigrationImpl migration = PsiMigrationManager.getInstance(this.myProject).getCurrentMigration();
        if (migration != null) {
            List<PsiClass> classes = migration.getMigrationClasses(psiPackage.getQualifiedName());
            return classes.toArray(new PsiClass[classes.size()]);
        }
        return PsiClass.EMPTY_ARRAY;
    }

    @NotNull
    public PsiPackage[] getSubPackages(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope) {
        PsiMigrationImpl migration = PsiMigrationManager.getInstance(this.myProject).getCurrentMigration();
        if (migration != null) {
            List<PsiPackage> packages = migration.getMigrationPackages(psiPackage.getQualifiedName());
            return packages.toArray(new PsiPackage[packages.size()]);
        }
        return PsiPackage.EMPTY_ARRAY;
    }

    public PsiPackage findPackage(@NotNull String qualifiedName) {
        PsiMigrationImpl migration = PsiMigrationManager.getInstance(this.myProject).getCurrentMigration();
        if (migration != null) {
            return migration.getMigrationPackage(qualifiedName);
        }
        return null;
    }
}

