/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.meta;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataCache;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.patterns.ElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.filters.position.PatternFilter;
import com.intellij.psi.meta.MetaDataContributor;
import com.intellij.psi.meta.MetaDataRegistrar;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MetaRegistry
extends MetaDataRegistrar {
    private static final Logger LOG = Logger.getInstance(MetaRegistry.class);
    private static final List<MyBinding> ourBindings = ContainerUtil.createLockFreeCopyOnWriteList();
    private static volatile boolean ourContributorsLoaded = false;
    private static final Key<CachedValue<PsiMetaData>> META_DATA_KEY = Key.create((String)"META DATA KEY");
    private static final UserDataCache<CachedValue<PsiMetaData>, PsiElement, Object> ourCachedMetaCache = new UserDataCache<CachedValue<PsiMetaData>, PsiElement, Object>(){

        protected CachedValue<PsiMetaData> compute(final PsiElement element, Object p) {
            return CachedValuesManager.getManager((Project)element.getProject()).createCachedValue((CachedValueProvider)new CachedValueProvider<PsiMetaData>(){

                public CachedValueProvider.Result<PsiMetaData> compute() {
                    MetaRegistry.ensureContributorsLoaded();
                    for (MyBinding binding : ourBindings) {
                        Object[] dependences;
                        PsiMetaData data;
                        if (!binding.myFilter.isClassAcceptable(element.getClass()) || !binding.myFilter.isAcceptable((Object)element, element.getParent())) continue;
                        try {
                            data = (PsiMetaData)binding.myDataClass.newInstance();
                        }
                        catch (InstantiationException e) {
                            throw new RuntimeException("failed to instantiate " + binding.myDataClass, e);
                        }
                        catch (IllegalAccessException e) {
                            throw new RuntimeException("failed to instantiate " + binding.myDataClass, e);
                        }
                        data.init(element);
                        for (Object dependence : dependences = data.getDependences()) {
                            if (dependence != null) continue;
                            LOG.error(data + "(" + binding.myDataClass + ") provided null dependency");
                        }
                        return new CachedValueProvider.Result((Object)data, ArrayUtil.append((Object[])dependences, (Object)element));
                    }
                    return new CachedValueProvider.Result(null, new Object[]{element});
                }
            }, false);
        }
    };

    public static void bindDataToElement(final PsiElement element, final PsiMetaData data) {
        CachedValue value = CachedValuesManager.getManager((Project)element.getProject()).createCachedValue((CachedValueProvider)new CachedValueProvider<PsiMetaData>(){

            public CachedValueProvider.Result<PsiMetaData> compute() {
                data.init(element);
                return new CachedValueProvider.Result((Object)data, data.getDependences());
            }
        });
        element.putUserData(META_DATA_KEY, (Object)value);
    }

    public static PsiMetaData getMeta(PsiElement element) {
        PsiMetaData base = MetaRegistry.getMetaBase(element);
        return base != null ? base : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void ensureContributorsLoaded() {
        if (!ourContributorsLoaded) {
            List<MyBinding> list = ourBindings;
            synchronized (list) {
                if (!ourContributorsLoaded) {
                    for (MetaDataContributor contributor : (MetaDataContributor[])Extensions.getExtensions((ExtensionPointName)MetaDataContributor.EP_NAME)) {
                        contributor.contributeMetaData(MetaDataRegistrar.getInstance());
                    }
                    ourContributorsLoaded = true;
                }
            }
        }
    }

    @Nullable
    public static PsiMetaData getMetaBase(PsiElement element) {
        ProgressIndicatorProvider.checkCanceled();
        return (PsiMetaData)((CachedValue)ourCachedMetaCache.get(META_DATA_KEY, (UserDataHolder)element, null)).getValue();
    }

    public static <T extends PsiMetaData> void addMetadataBinding(ElementFilter filter, Class<T> aMetadataClass, Disposable parentDisposable) {
        final MyBinding binding = new MyBinding(filter, aMetadataClass);
        MetaRegistry.addBinding(binding);
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

            public void dispose() {
                ourBindings.remove(binding);
            }
        });
    }

    public static <T extends PsiMetaData> void addMetadataBinding(ElementFilter filter, Class<T> aMetadataClass) {
        MetaRegistry.addBinding(new MyBinding(filter, aMetadataClass));
    }

    private static void addBinding(MyBinding binding) {
        ourBindings.add(0, binding);
    }

    public <T extends PsiMetaData> void registerMetaData(ElementFilter filter, Class<T> metadataDescriptorClass) {
        MetaRegistry.addMetadataBinding(filter, metadataDescriptorClass);
    }

    public <T extends PsiMetaData> void registerMetaData(ElementPattern<?> pattern, Class<T> metadataDescriptorClass) {
        MetaRegistry.addMetadataBinding((ElementFilter)new PatternFilter(pattern), metadataDescriptorClass);
    }

    private static class MyBinding {
        private final ElementFilter myFilter;
        private final Class<? extends PsiMetaData> myDataClass;

        public MyBinding(@NotNull ElementFilter filter, @NotNull Class<? extends PsiMetaData> dataClass) {
            this.myFilter = filter;
            this.myDataClass = dataClass;
        }
    }
}

