/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.light;

import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.OriginInfoAwareElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.ElementPresentationUtil;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.psi.impl.light.LightModifierList;
import com.intellij.ui.RowIcon;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PlatformIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LightVariableBuilder<T extends LightVariableBuilder>
extends LightElement
implements PsiVariable,
NavigationItem,
OriginInfoAwareElement {
    private final String myName;
    private final PsiType myType;
    private volatile LightModifierList myModifierList;
    private volatile Icon myBaseIcon = PlatformIcons.VARIABLE_ICON;
    private String myOriginInfo;

    public LightVariableBuilder(@NotNull String name, @NotNull String type, @NotNull PsiElement navigationElement) {
        this(name, JavaPsiFacade.getElementFactory((Project)navigationElement.getProject()).createTypeFromText(type, navigationElement), navigationElement);
    }

    public LightVariableBuilder(@NotNull String name, @NotNull PsiType type, @NotNull PsiElement navigationElement) {
        this(navigationElement.getManager(), name, type, (Language)JavaLanguage.INSTANCE);
        this.setNavigationElement(navigationElement);
    }

    public LightVariableBuilder(PsiManager manager, @NotNull String name, @NotNull PsiType type, @NotNull Language language) {
        super(manager, language);
        this.myName = name;
        this.myType = type;
        this.myModifierList = new LightModifierList(manager);
    }

    @Override
    public String toString() {
        return "LightVariableBuilder:" + this.getName();
    }

    @NotNull
    public PsiType getType() {
        return this.myType;
    }

    @NotNull
    public PsiModifierList getModifierList() {
        return this.myModifierList;
    }

    public T setModifiers(String ... modifiers) {
        this.myModifierList = new LightModifierList(this.getManager(), this.getLanguage(), modifiers);
        return (T)((Object)this);
    }

    public T setModifierList(LightModifierList modifierList) {
        this.myModifierList = modifierList;
        return (T)((Object)this);
    }

    public boolean hasModifierProperty(@NonNls @NotNull String name) {
        return this.myModifierList.hasModifierProperty(name);
    }

    @Override
    @NotNull
    public String getName() {
        return this.myName;
    }

    public PsiTypeElement getTypeElement() {
        return null;
    }

    public PsiExpression getInitializer() {
        return null;
    }

    public boolean hasInitializer() {
        return false;
    }

    public void normalizeDeclaration() throws IncorrectOperationException {
    }

    public Object computeConstantValue() {
        return null;
    }

    public PsiIdentifier getNameIdentifier() {
        return null;
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        throw new UnsupportedOperationException("setName is not implemented yet in com.intellij.psi.impl.light.LightVariableBuilder");
    }

    protected boolean isVisibilitySupported() {
        return true;
    }

    public Icon getElementIcon(int flags) {
        RowIcon baseIcon = ElementPresentationUtil.createLayeredIcon(this.myBaseIcon, (PsiModifierListOwner)this, false);
        return ElementPresentationUtil.addVisibilityIcon((PsiModifierListOwner)this, flags, baseIcon);
    }

    public T setBaseIcon(Icon baseIcon) {
        this.myBaseIcon = baseIcon;
        return (T)((Object)this);
    }

    @Nullable
    public String getOriginInfo() {
        return this.myOriginInfo;
    }

    public void setOriginInfo(@Nullable String originInfo) {
        this.myOriginInfo = originInfo;
    }
}

