/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.light;

import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.OriginInfoAwareElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.ElementPresentationUtil;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.psi.impl.light.LightModifierList;
import com.intellij.ui.RowIcon;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PlatformIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LightVariableBase
extends LightElement
implements PsiVariable,
OriginInfoAwareElement {
    protected PsiElement myScope;
    protected PsiIdentifier myNameIdentifier;
    protected PsiType myType;
    protected final PsiModifierList myModifierList;
    protected boolean myWritable;
    private String myOriginInfo = null;

    public LightVariableBase(PsiManager manager, PsiIdentifier nameIdentifier, PsiType type, boolean writable, PsiElement scope) {
        this(manager, nameIdentifier, (Language)JavaLanguage.INSTANCE, type, writable, scope);
    }

    public LightVariableBase(PsiManager manager, PsiIdentifier nameIdentifier, Language language, PsiType type, boolean writable, PsiElement scope) {
        super(manager, language);
        this.myNameIdentifier = nameIdentifier;
        this.myWritable = writable;
        this.myType = type;
        this.myScope = scope;
        this.myModifierList = this.createModifierList();
    }

    protected PsiModifierList createModifierList() {
        return new LightModifierList(this.getManager());
    }

    @NotNull
    public PsiElement getDeclarationScope() {
        return this.myScope;
    }

    public PsiIdentifier getNameIdentifier() {
        return this.myNameIdentifier;
    }

    @Override
    public boolean isValid() {
        return this.myNameIdentifier == null || this.myNameIdentifier.isValid();
    }

    @Override
    @NotNull
    public String getName() {
        return StringUtil.notNullize((String)this.getNameIdentifier().getText());
    }

    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        PsiImplUtil.setName((PsiElement)this.getNameIdentifier(), name);
        return this;
    }

    @NotNull
    public PsiType getType() {
        if (this.myType == null) {
            this.myType = this.computeType();
        }
        return this.myType;
    }

    @NotNull
    protected PsiType computeType() {
        return PsiType.VOID;
    }

    @NotNull
    public PsiTypeElement getTypeElement() {
        return JavaPsiFacade.getInstance((Project)this.getProject()).getElementFactory().createTypeElement(this.myType);
    }

    public PsiModifierList getModifierList() {
        return this.myModifierList;
    }

    public boolean hasModifierProperty(@NotNull String name) {
        return this.getModifierList().hasModifierProperty(name);
    }

    public PsiExpression getInitializer() {
        return null;
    }

    public boolean hasInitializer() {
        return false;
    }

    @Override
    public String getText() {
        return this.myNameIdentifier.getText();
    }

    public Object computeConstantValue() {
        return null;
    }

    public void normalizeDeclaration() throws IncorrectOperationException {
    }

    @Override
    public boolean isWritable() {
        return this.myWritable;
    }

    protected boolean isVisibilitySupported() {
        return true;
    }

    public Icon getElementIcon(int flags) {
        RowIcon baseIcon = ElementPresentationUtil.createLayeredIcon(PlatformIcons.VARIABLE_ICON, (PsiModifierListOwner)this, false);
        return ElementPresentationUtil.addVisibilityIcon((PsiModifierListOwner)this, flags, baseIcon);
    }

    @Nullable
    public String getOriginInfo() {
        return this.myOriginInfo;
    }

    public void setOriginInfo(String originInfo) {
        this.myOriginInfo = originInfo;
    }
}

