/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.light;

import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class LightReferenceListBuilder
extends LightElement
implements PsiReferenceList {
    private final List<PsiJavaCodeReferenceElement> myRefs = new ArrayList<PsiJavaCodeReferenceElement>();
    private PsiJavaCodeReferenceElement[] myCachedRefs = null;
    private PsiClassType[] myCachedTypes = null;
    private final PsiReferenceList.Role myRole;
    private final PsiElementFactory myFactory;

    public LightReferenceListBuilder(PsiManager manager, PsiReferenceList.Role role) {
        this(manager, (Language)JavaLanguage.INSTANCE, role);
    }

    public LightReferenceListBuilder(PsiManager manager, Language language, PsiReferenceList.Role role) {
        super(manager, language);
        this.myRole = role;
        this.myFactory = JavaPsiFacade.getElementFactory((Project)this.getProject());
    }

    @Override
    public String toString() {
        return "light reference list";
    }

    public void addReference(PsiClass aClass) {
        this.addReference(aClass.getQualifiedName());
    }

    public void addReference(String qualifiedName) {
        PsiJavaCodeReferenceElement ref = this.myFactory.createReferenceElementByFQClassName(qualifiedName, this.getResolveScope());
        this.myRefs.add(ref);
    }

    public void addReference(PsiClassType type) {
        PsiClass resolved = type.resolve();
        if (resolved == null) {
            return;
        }
        PsiJavaCodeReferenceElement ref = this.myFactory.createReferenceElementByType(type);
        this.myRefs.add(ref);
    }

    @NotNull
    public PsiJavaCodeReferenceElement[] getReferenceElements() {
        if (this.myCachedRefs == null) {
            this.myCachedRefs = this.myRefs.isEmpty() ? PsiJavaCodeReferenceElement.EMPTY_ARRAY : (PsiJavaCodeReferenceElement[])ContainerUtil.toArray(this.myRefs, (Object[])new PsiJavaCodeReferenceElement[this.myRefs.size()]);
        }
        return this.myCachedRefs;
    }

    @NotNull
    public PsiClassType[] getReferencedTypes() {
        if (this.myCachedTypes == null) {
            if (this.myRefs.isEmpty()) {
                this.myCachedTypes = PsiClassType.EMPTY_ARRAY;
            } else {
                int size = this.myRefs.size();
                this.myCachedTypes = new PsiClassType[size];
                for (int i = 0; i < size; ++i) {
                    this.myCachedTypes[i] = this.myFactory.createType(this.myRefs.get(i));
                }
            }
        }
        return this.myCachedTypes;
    }

    public PsiReferenceList.Role getRole() {
        return this.myRole;
    }
}

