/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.light;

import com.intellij.psi.OriginInfoAwareElement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.impl.PsiClassImplUtil;
import com.intellij.psi.impl.light.LightMethodBuilder;
import com.intellij.psi.impl.light.LightModifierList;
import com.intellij.psi.impl.light.LightPsiClassBase;
import com.intellij.psi.impl.light.LightReferenceListBuilder;
import com.intellij.psi.impl.light.LightTypeParameterListBuilder;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LightPsiClassBuilder
extends LightPsiClassBase
implements OriginInfoAwareElement {
    private final LightModifierList myModifierList = new LightModifierList(this.getManager());
    private final LightReferenceListBuilder myImplementsList = new LightReferenceListBuilder(this.getManager(), PsiReferenceList.Role.IMPLEMENTS_LIST);
    private final LightReferenceListBuilder myExtendsList = new LightReferenceListBuilder(this.getManager(), PsiReferenceList.Role.EXTENDS_LIST);
    private final LightTypeParameterListBuilder myTypeParametersList = new LightTypeParameterListBuilder(this.getManager(), this.getLanguage());
    private final Collection<PsiMethod> myMethods = ContainerUtil.newArrayList();
    private PsiElement myScope;
    private PsiClass myContainingClass;
    private String myOriginInfo;

    public LightPsiClassBuilder(@NotNull PsiElement context, @NotNull String name) {
        super(context, name);
    }

    @Nullable
    public String getOriginInfo() {
        return this.myOriginInfo;
    }

    @Override
    @NotNull
    public LightModifierList getModifierList() {
        return this.myModifierList;
    }

    @NotNull
    public LightReferenceListBuilder getExtendsList() {
        return this.myExtendsList;
    }

    @NotNull
    public LightReferenceListBuilder getImplementsList() {
        return this.myImplementsList;
    }

    @NotNull
    public PsiField[] getFields() {
        return PsiField.EMPTY_ARRAY;
    }

    @NotNull
    public PsiMethod[] getMethods() {
        return this.myMethods.toArray(new PsiMethod[this.myMethods.size()]);
    }

    @NotNull
    public PsiClass[] getInnerClasses() {
        return PsiClass.EMPTY_ARRAY;
    }

    @NotNull
    public PsiClassInitializer[] getInitializers() {
        return PsiClassInitializer.EMPTY_ARRAY;
    }

    public PsiElement getScope() {
        return this.myScope;
    }

    @Nullable
    public PsiClass getContainingClass() {
        return this.myContainingClass;
    }

    @NotNull
    public LightTypeParameterListBuilder getTypeParameterList() {
        return this.myTypeParametersList;
    }

    @Override
    public boolean isEquivalentTo(PsiElement another) {
        return PsiClassImplUtil.isClassEquivalentTo(this, another);
    }

    public LightPsiClassBuilder setOriginInfo(String originInfo) {
        this.myOriginInfo = originInfo;
        return this;
    }

    public LightPsiClassBuilder setScope(PsiElement scope) {
        this.myScope = scope;
        return this;
    }

    public LightPsiClassBuilder setContainingClass(PsiClass containingClass) {
        this.myContainingClass = containingClass;
        return this;
    }

    public LightPsiClassBuilder addMethod(PsiMethod method) {
        if (method instanceof LightMethodBuilder) {
            ((LightMethodBuilder)method).setContainingClass(this);
        }
        this.myMethods.add(method);
        return this;
    }
}

