/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.light;

import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.ItemPresentationProviders;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.impl.ElementPresentationUtil;
import com.intellij.psi.impl.PsiClassImplUtil;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import com.intellij.ui.RowIcon;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PlatformIcons;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class LightMethod
extends LightElement
implements PsiMethod {
    private final PsiMethod myMethod;
    private final PsiClass myContainingClass;

    public LightMethod(@NotNull PsiManager manager, @NotNull PsiMethod method, @NotNull PsiClass containingClass) {
        this(manager, method, containingClass, (Language)JavaLanguage.INSTANCE);
    }

    public LightMethod(@NotNull PsiManager manager, @NotNull PsiMethod method, @NotNull PsiClass containingClass, @NotNull Language language) {
        super(manager, language);
        this.myMethod = method;
        this.myContainingClass = containingClass;
    }

    @Override
    public ItemPresentation getPresentation() {
        return ItemPresentationProviders.getItemPresentation((NavigationItem)this);
    }

    public boolean hasTypeParameters() {
        return this.myMethod.hasTypeParameters();
    }

    @NotNull
    public PsiTypeParameter[] getTypeParameters() {
        return this.myMethod.getTypeParameters();
    }

    public PsiTypeParameterList getTypeParameterList() {
        return this.myMethod.getTypeParameterList();
    }

    public PsiDocComment getDocComment() {
        return this.myMethod.getDocComment();
    }

    public boolean isDeprecated() {
        return this.myMethod.isDeprecated();
    }

    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        return this.myMethod.setName(name);
    }

    @Override
    @NotNull
    public String getName() {
        return this.myMethod.getName();
    }

    @NotNull
    public HierarchicalMethodSignature getHierarchicalMethodSignature() {
        return this.myMethod.getHierarchicalMethodSignature();
    }

    public boolean hasModifierProperty(@NotNull String name) {
        return this.myMethod.hasModifierProperty(name);
    }

    @Override
    public TextRange getTextRange() {
        return this.myMethod.getTextRange();
    }

    @NotNull
    public PsiModifierList getModifierList() {
        return this.myMethod.getModifierList();
    }

    public PsiType getReturnType() {
        return this.myMethod.getReturnType();
    }

    public PsiTypeElement getReturnTypeElement() {
        return this.myMethod.getReturnTypeElement();
    }

    @NotNull
    public PsiParameterList getParameterList() {
        return this.myMethod.getParameterList();
    }

    @NotNull
    public PsiReferenceList getThrowsList() {
        return this.myMethod.getThrowsList();
    }

    public PsiCodeBlock getBody() {
        return this.myMethod.getBody();
    }

    public boolean isConstructor() {
        return this.myMethod.isConstructor();
    }

    public boolean isVarArgs() {
        return this.myMethod.isVarArgs();
    }

    @NotNull
    public MethodSignature getSignature(@NotNull PsiSubstitutor substitutor) {
        return this.myMethod.getSignature(substitutor);
    }

    public PsiIdentifier getNameIdentifier() {
        return this.myMethod.getNameIdentifier();
    }

    @NotNull
    public PsiMethod[] findSuperMethods() {
        return this.myMethod.findSuperMethods();
    }

    @NotNull
    public PsiMethod[] findSuperMethods(boolean checkAccess) {
        return this.myMethod.findSuperMethods(checkAccess);
    }

    @NotNull
    public PsiMethod[] findSuperMethods(PsiClass parentClass) {
        return this.myMethod.findSuperMethods(parentClass);
    }

    @NotNull
    public List<MethodSignatureBackedByPsiMethod> findSuperMethodSignaturesIncludingStatic(boolean checkAccess) {
        return this.myMethod.findSuperMethodSignaturesIncludingStatic(checkAccess);
    }

    public PsiMethod findDeepestSuperMethod() {
        return this.myMethod.findDeepestSuperMethod();
    }

    @NotNull
    public PsiMethod[] findDeepestSuperMethods() {
        return this.myMethod.findDeepestSuperMethods();
    }

    @Override
    public String getText() {
        return this.myMethod.getText();
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        this.myMethod.accept(visitor);
    }

    @Override
    public PsiElement copy() {
        return new LightMethod(this.myManager, (PsiMethod)this.myMethod.copy(), this.myContainingClass);
    }

    @Override
    public boolean isValid() {
        return this.myContainingClass.isValid();
    }

    public PsiClass getContainingClass() {
        return this.myContainingClass;
    }

    @Override
    public PsiFile getContainingFile() {
        return this.myContainingClass.getContainingFile();
    }

    @Override
    public String toString() {
        return "PsiMethod:" + this.getName();
    }

    protected boolean isVisibilitySupported() {
        return true;
    }

    public Icon getElementIcon(int flags) {
        Icon methodIcon = this.hasModifierProperty("abstract") ? PlatformIcons.ABSTRACT_METHOD_ICON : PlatformIcons.METHOD_ICON;
        RowIcon baseIcon = ElementPresentationUtil.createLayeredIcon(methodIcon, (PsiModifierListOwner)this, false);
        return ElementPresentationUtil.addVisibilityIcon((PsiModifierListOwner)this, flags, baseIcon);
    }

    @Override
    public boolean isEquivalentTo(PsiElement another) {
        return PsiClassImplUtil.isMethodEquivalentTo(this, another);
    }

    @Override
    @NotNull
    public SearchScope getUseScope() {
        return PsiImplUtil.getMemberUseScope((PsiMember)this);
    }

    @Override
    public PsiElement getContext() {
        return this.getContainingClass();
    }
}

