/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.java.stubs.impl;

import com.intellij.psi.PsiMethod;
import com.intellij.psi.impl.cache.TypeInfo;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.PsiMethodStub;
import com.intellij.psi.impl.java.stubs.PsiParameterListStub;
import com.intellij.psi.impl.java.stubs.PsiParameterStub;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.StubBase;
import com.intellij.psi.stubs.StubElement;
import com.intellij.util.BitUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiMethodStubImpl
extends StubBase<PsiMethod>
implements PsiMethodStub {
    private final TypeInfo myReturnType;
    private final byte myFlags;
    private final String myName;
    private String myDefaultValueText;
    private static final int CONSTRUCTOR = 1;
    private static final int VARARGS = 2;
    private static final int ANNOTATION = 4;
    private static final int DEPRECATED = 8;
    private static final int DEPRECATED_ANNOTATION = 16;
    private static final int HAS_DOC_COMMENT = 32;

    public PsiMethodStubImpl(StubElement parent, String name, @NotNull TypeInfo returnType, byte flags, @Nullable String defaultValueText) {
        super(parent, (IStubElementType)(PsiMethodStubImpl.isAnnotationMethod(flags) ? JavaStubElementTypes.ANNOTATION_METHOD : JavaStubElementTypes.METHOD));
        this.myReturnType = returnType;
        this.myFlags = flags;
        this.myName = name;
        this.myDefaultValueText = defaultValueText;
    }

    @Override
    public boolean isConstructor() {
        return BitUtil.isSet((int)this.myFlags, (int)1);
    }

    @Override
    public boolean isVarArgs() {
        return BitUtil.isSet((int)this.myFlags, (int)2);
    }

    @Override
    public boolean isAnnotationMethod() {
        return PsiMethodStubImpl.isAnnotationMethod(this.myFlags);
    }

    public static boolean isAnnotationMethod(byte flags) {
        return (flags & 4) != 0;
    }

    @Override
    public String getDefaultValueText() {
        return this.myDefaultValueText;
    }

    @Override
    @NotNull
    public TypeInfo getReturnTypeText(boolean doResolve) {
        return doResolve ? this.myReturnType.applyAnnotations(this) : this.myReturnType;
    }

    @Override
    public boolean isDeprecated() {
        return (this.myFlags & 8) != 0;
    }

    @Override
    public boolean hasDeprecatedAnnotation() {
        return (this.myFlags & 0x10) != 0;
    }

    @Override
    public boolean hasDocComment() {
        return (this.myFlags & 0x20) != 0;
    }

    @Override
    public PsiParameterStub findParameter(int idx) {
        PsiParameterListStub list = null;
        for (StubElement child : this.getChildrenStubs()) {
            if (!(child instanceof PsiParameterListStub)) continue;
            list = (PsiParameterListStub)child;
            break;
        }
        if (list != null) {
            List params = list.getChildrenStubs();
            return (PsiParameterStub)params.get(idx);
        }
        throw new RuntimeException("No parameter(s) [yet?]");
    }

    public String getName() {
        return this.myName;
    }

    public byte getFlags() {
        return this.myFlags;
    }

    public void setDefaultValueText(String defaultValueText) {
        this.myDefaultValueText = defaultValueText;
    }

    public static byte packFlags(boolean isConstructor, boolean isAnnotationMethod, boolean isVarargs, boolean isDeprecated, boolean hasDeprecatedAnnotation, boolean hasDocComment) {
        byte flags = 0;
        if (isConstructor) {
            flags = (byte)(flags | 1);
        }
        if (isAnnotationMethod) {
            flags = (byte)(flags | 4);
        }
        if (isVarargs) {
            flags = (byte)(flags | 2);
        }
        if (isDeprecated) {
            flags = (byte)(flags | 8);
        }
        if (hasDeprecatedAnnotation) {
            flags = (byte)(flags | 0x10);
        }
        if (hasDocComment) {
            flags = (byte)(flags | 0x20);
        }
        return flags;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("PsiMethodStub[");
        if (this.isConstructor()) {
            builder.append("cons ");
        }
        if (this.isAnnotationMethod()) {
            builder.append("annotation ");
        }
        if (this.isVarArgs()) {
            builder.append("varargs ");
        }
        if (this.isDeprecated() || this.hasDeprecatedAnnotation()) {
            builder.append("deprecated ");
        }
        builder.append(this.myName).append(":").append(this.myReturnType);
        String defaultValue = this.getDefaultValueText();
        if (defaultValue != null) {
            builder.append(" default=").append(defaultValue);
        }
        builder.append("]");
        return builder.toString();
    }
}

