/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.java.stubs;

import com.intellij.lang.ASTNode;
import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.impl.cache.RecordUtil;
import com.intellij.psi.impl.cache.TypeInfo;
import com.intellij.psi.impl.java.stubs.JavaStubElementType;
import com.intellij.psi.impl.java.stubs.PsiParameterStub;
import com.intellij.psi.impl.java.stubs.impl.PsiParameterStubImpl;
import com.intellij.psi.impl.source.PsiParameterImpl;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.LightTreeUtil;
import com.intellij.psi.impl.source.tree.java.ParameterElement;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.util.io.StringRef;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class JavaParameterElementType
extends JavaStubElementType<PsiParameterStub, PsiParameter> {
    public JavaParameterElementType() {
        super("PARAMETER");
    }

    @NotNull
    public ASTNode createCompositeNode() {
        return new ParameterElement(JavaElementType.PARAMETER);
    }

    public PsiParameter createPsi(@NotNull PsiParameterStub stub) {
        return this.getPsiFactory(stub).createParameter(stub);
    }

    @Override
    public PsiParameter createPsi(@NotNull ASTNode node) {
        return new PsiParameterImpl(node);
    }

    public PsiParameterStub createStub(LighterAST tree, LighterASTNode node, StubElement parentStub) {
        TypeInfo typeInfo = TypeInfo.create(tree, node, parentStub);
        LighterASTNode id = LightTreeUtil.requiredChildOfType(tree, node, JavaTokenType.IDENTIFIER);
        String name = RecordUtil.intern(tree.getCharTable(), id);
        return new PsiParameterStubImpl(parentStub, name, typeInfo, typeInfo.isEllipsis);
    }

    public void serialize(@NotNull PsiParameterStub stub, @NotNull StubOutputStream dataStream) throws IOException {
        dataStream.writeName(stub.getName());
        TypeInfo.writeTYPE(dataStream, stub.getType(false));
        dataStream.writeBoolean(stub.isParameterTypeEllipsis());
    }

    @NotNull
    public PsiParameterStub deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        StringRef name = dataStream.readName();
        TypeInfo type = TypeInfo.readTYPE(dataStream);
        boolean isEllipsis = dataStream.readBoolean();
        return new PsiParameterStubImpl(parentStub, name, type, isEllipsis);
    }

    public void indexStub(@NotNull PsiParameterStub stub, @NotNull IndexSink sink) {
    }
}

