/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.java.stubs;

import com.intellij.lang.ASTNode;
import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.impl.cache.RecordUtil;
import com.intellij.psi.impl.java.stubs.JavaStubElementType;
import com.intellij.psi.impl.java.stubs.PsiNameValuePairStub;
import com.intellij.psi.impl.java.stubs.impl.PsiNameValuePairStubImpl;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.java.NameValuePairElement;
import com.intellij.psi.impl.source.tree.java.PsiNameValuePairImpl;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.util.io.StringRef;
import java.io.IOException;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JavaNameValuePairType
extends JavaStubElementType<PsiNameValuePairStub, PsiNameValuePair> {
    protected JavaNameValuePairType() {
        super("NAME_VALUE_PAIR", true);
    }

    @Override
    public PsiNameValuePair createPsi(@NotNull ASTNode node) {
        return new PsiNameValuePairImpl(node);
    }

    @NotNull
    public ASTNode createCompositeNode() {
        return new NameValuePairElement();
    }

    public PsiNameValuePairStub createStub(LighterAST tree, LighterASTNode node, StubElement parentStub) {
        String name = null;
        String value = null;
        List children2 = tree.getChildren(node);
        for (LighterASTNode child : children2) {
            if (child.getTokenType() == JavaTokenType.IDENTIFIER) {
                name = RecordUtil.intern(tree.getCharTable(), child);
                continue;
            }
            if (child.getTokenType() != JavaElementType.LITERAL_EXPRESSION) continue;
            value = RecordUtil.intern(tree.getCharTable(), (LighterASTNode)tree.getChildren(child).get(0));
            value = StringUtil.unquoteString((String)value);
        }
        return new PsiNameValuePairStubImpl(parentStub, StringRef.fromString(name), StringRef.fromString(value));
    }

    public PsiNameValuePair createPsi(@NotNull PsiNameValuePairStub stub) {
        return this.getPsiFactory(stub).createNameValuePair(stub);
    }

    public void serialize(@NotNull PsiNameValuePairStub stub, @NotNull StubOutputStream dataStream) throws IOException {
        dataStream.writeName(stub.getName());
        dataStream.writeName(stub.getValue());
    }

    @NotNull
    public PsiNameValuePairStub deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        StringRef name = dataStream.readName();
        return new PsiNameValuePairStubImpl(parentStub, name, dataStream.readName());
    }

    public void indexStub(@NotNull PsiNameValuePairStub stub, @NotNull IndexSink sink) {
    }
}

