/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.java.stubs;

import com.intellij.lang.ASTNode;
import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.impl.java.stubs.JavaStubElementType;
import com.intellij.psi.impl.java.stubs.PsiAnnotationStub;
import com.intellij.psi.impl.java.stubs.impl.PsiAnnotationStubImpl;
import com.intellij.psi.impl.java.stubs.index.JavaStubIndexKeys;
import com.intellij.psi.impl.source.tree.LightTreeUtil;
import com.intellij.psi.impl.source.tree.java.AnnotationElement;
import com.intellij.psi.impl.source.tree.java.PsiAnnotationImpl;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class JavaAnnotationElementType
extends JavaStubElementType<PsiAnnotationStub, PsiAnnotation> {
    public JavaAnnotationElementType() {
        super("ANNOTATION");
    }

    @NotNull
    public ASTNode createCompositeNode() {
        return new AnnotationElement();
    }

    public PsiAnnotation createPsi(@NotNull PsiAnnotationStub stub) {
        return this.getPsiFactory(stub).createAnnotation(stub);
    }

    @Override
    public PsiAnnotation createPsi(@NotNull ASTNode node) {
        return new PsiAnnotationImpl(node);
    }

    public PsiAnnotationStub createStub(LighterAST tree, LighterASTNode node, StubElement parentStub) {
        String text = LightTreeUtil.toFilteredString(tree, node, null);
        return new PsiAnnotationStubImpl(parentStub, text);
    }

    public void serialize(@NotNull PsiAnnotationStub stub, @NotNull StubOutputStream dataStream) throws IOException {
        dataStream.writeUTFFast(stub.getText());
    }

    @NotNull
    public PsiAnnotationStub deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        return new PsiAnnotationStubImpl(parentStub, dataStream.readUTFFast());
    }

    public void indexStub(@NotNull PsiAnnotationStub stub, @NotNull IndexSink sink) {
        String shortName = JavaAnnotationElementType.getReferenceShortName(stub.getText());
        if (!StringUtil.isEmptyOrSpaces((String)shortName)) {
            sink.occurrence(JavaStubIndexKeys.ANNOTATIONS, (Object)shortName);
        }
    }

    private static String getReferenceShortName(String annotationText) {
        int index = annotationText.indexOf(40);
        if (index >= 0) {
            annotationText = annotationText.substring(0, index);
        }
        return PsiNameHelper.getShortClassName((String)annotationText);
    }
}

