/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.file;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.PsiElementBase;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.RowIcon;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PsiPackageBase
extends PsiElementBase
implements PsiDirectoryContainer,
Queryable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.file.PsiPackageBase");
    final PsiManager myManager;
    private final String myQualifiedName;

    protected Collection<PsiDirectory> getAllDirectories() {
        return this.getAllDirectories(false);
    }

    protected abstract Collection<PsiDirectory> getAllDirectories(boolean var1);

    protected abstract PsiElement findPackage(String var1);

    protected abstract PsiPackageBase createInstance(PsiManager var1, String var2);

    public PsiPackageBase(PsiManager manager, String qualifiedName) {
        this.myManager = manager;
        this.myQualifiedName = qualifiedName;
    }

    public boolean equals(Object o) {
        return o != null && ((Object)((Object)this)).getClass() == o.getClass() && this.myManager == ((PsiPackageBase)((Object)o)).myManager && this.myQualifiedName.equals(((PsiPackageBase)((Object)o)).myQualifiedName);
    }

    public int hashCode() {
        return this.myQualifiedName.hashCode();
    }

    @NotNull
    public String getQualifiedName() {
        return this.myQualifiedName;
    }

    @NotNull
    public PsiDirectory[] getDirectories() {
        Collection<PsiDirectory> collection = this.getAllDirectories();
        return (PsiDirectory[])ContainerUtil.toArray(collection, (Object[])new PsiDirectory[collection.size()]);
    }

    @NotNull
    public PsiDirectory[] getDirectories(@NotNull GlobalSearchScope scope) {
        ArrayList<PsiDirectory> result = null;
        boolean includeLibrarySources = scope.isForceSearchingInLibrarySources();
        Collection<PsiDirectory> directories = this.getAllDirectories(includeLibrarySources);
        for (PsiDirectory directory : directories) {
            if (!scope.contains(directory.getVirtualFile())) continue;
            if (result == null) {
                result = new ArrayList<PsiDirectory>();
            }
            result.add(directory);
        }
        return result == null ? PsiDirectory.EMPTY_ARRAY : result.toArray(new PsiDirectory[result.size()]);
    }

    public RowIcon getElementIcon(int elementFlags) {
        return PsiPackageBase.createLayeredIcon((Iconable)this, (Icon)PlatformIcons.PACKAGE_ICON, (int)elementFlags);
    }

    @Override
    public String getName() {
        if (DebugUtil.CHECK_INSIDE_ATOMIC_ACTION_ENABLED) {
            ApplicationManager.getApplication().assertReadAccessAllowed();
        }
        if (this.myQualifiedName.isEmpty()) {
            return null;
        }
        int index = this.myQualifiedName.lastIndexOf(46);
        if (index <= 0) {
            return this.myQualifiedName;
        }
        return this.myQualifiedName.substring(index + 1);
    }

    @Nullable
    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        PsiDirectory[] dirs;
        this.checkSetName(name);
        for (PsiDirectory dir : dirs = this.getDirectories()) {
            dir.setName(name);
        }
        String nameAfterRename = PsiUtilCore.getQualifiedNameAfterRename((String)this.getQualifiedName(), (String)name);
        return this.findPackage(nameAfterRename);
    }

    public void checkSetName(@NotNull String name) throws IncorrectOperationException {
        PsiDirectory[] dirs;
        for (PsiDirectory dir : dirs = this.getDirectories()) {
            dir.checkSetName(name);
        }
    }

    public PsiPackageBase getParentPackage() {
        if (this.myQualifiedName.isEmpty()) {
            return null;
        }
        int lastDot = this.myQualifiedName.lastIndexOf(46);
        if (lastDot < 0) {
            return this.createInstance(this.myManager, "");
        }
        return this.createInstance(this.myManager, this.myQualifiedName.substring(0, lastDot));
    }

    @Override
    public PsiManager getManager() {
        return this.myManager;
    }

    @NotNull
    public PsiElement[] getChildren() {
        LOG.error("method not implemented");
        return PsiElement.EMPTY_ARRAY;
    }

    @Nullable
    public PsiElement getParent() {
        return this.getParentPackage();
    }

    @Override
    @Nullable
    public PsiFile getContainingFile() {
        return null;
    }

    @Nullable
    public TextRange getTextRange() {
        return null;
    }

    public int getStartOffsetInParent() {
        return -1;
    }

    public int getTextLength() {
        return -1;
    }

    public PsiElement findElementAt(int offset) {
        return null;
    }

    public int getTextOffset() {
        return -1;
    }

    @Nullable
    public String getText() {
        return null;
    }

    @NotNull
    public char[] textToCharArray() {
        return ArrayUtil.EMPTY_CHAR_ARRAY;
    }

    @Override
    public boolean textMatches(@NotNull CharSequence text) {
        return false;
    }

    @Override
    public boolean textMatches(@NotNull PsiElement element) {
        return false;
    }

    @Override
    public PsiElement copy() {
        LOG.error("method not implemented");
        return null;
    }

    @Override
    public PsiElement add(@NotNull PsiElement element) throws IncorrectOperationException {
        throw new IncorrectOperationException();
    }

    @Override
    public PsiElement addBefore(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        throw new IncorrectOperationException();
    }

    @Override
    public PsiElement addAfter(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        throw new IncorrectOperationException();
    }

    @Override
    public void checkAdd(@NotNull PsiElement element) throws IncorrectOperationException {
        throw new IncorrectOperationException();
    }

    @Override
    public void delete() throws IncorrectOperationException {
        PsiDirectory[] dirs;
        this.checkDelete();
        for (PsiDirectory dir : dirs = this.getDirectories()) {
            dir.delete();
        }
    }

    @Override
    public void checkDelete() throws IncorrectOperationException {
        for (PsiDirectory dir : this.getDirectories()) {
            dir.checkDelete();
        }
    }

    @Override
    public PsiElement replace(@NotNull PsiElement newElement) throws IncorrectOperationException {
        throw new IncorrectOperationException();
    }

    @Override
    public boolean isWritable() {
        PsiDirectory[] dirs;
        for (PsiDirectory dir : dirs = this.getDirectories()) {
            if (dir.isWritable()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        visitor.visitElement((PsiElement)this);
    }

    public String toString() {
        return "PsiPackageBase:" + this.getQualifiedName();
    }

    @Override
    public boolean canNavigate() {
        return this.isValid();
    }

    @Override
    public boolean canNavigateToSource() {
        return false;
    }

    @Override
    public boolean isPhysical() {
        return true;
    }

    public ASTNode getNode() {
        return null;
    }

    public void putInfo(@NotNull Map<String, String> info) {
        info.put("packageName", this.getName());
        info.put("packageQualifiedName", this.getQualifiedName());
    }
}

