/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.file;

import com.intellij.lang.FileASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiBinaryFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.CheckUtil;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.PsiElementBase;
import com.intellij.psi.impl.PsiFileEx;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.file.PsiFileImplUtil;
import com.intellij.psi.impl.source.resolve.FileContextUtil;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import java.io.IOException;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiBinaryFileImpl
extends PsiElementBase
implements PsiBinaryFile,
PsiFileEx,
Cloneable,
Queryable {
    private final PsiManagerImpl myManager;
    private String myName;
    private byte[] myContents;
    private final long myModificationStamp;
    private final FileViewProvider myViewProvider;
    private boolean myInvalidated;

    public PsiBinaryFileImpl(PsiManagerImpl manager, FileViewProvider viewProvider) {
        this.myViewProvider = viewProvider;
        this.myManager = manager;
        VirtualFile virtualFile = this.myViewProvider.getVirtualFile();
        this.myModificationStamp = virtualFile.getModificationStamp();
    }

    @NotNull
    public VirtualFile getVirtualFile() {
        return this.myViewProvider.getVirtualFile();
    }

    public boolean processChildren(PsiElementProcessor<PsiFileSystemItem> processor2) {
        return true;
    }

    public byte[] getStoredContents() {
        return this.myContents;
    }

    @Override
    @NotNull
    public String getName() {
        return !this.isCopy() ? this.getVirtualFile().getName() : this.myName;
    }

    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        this.checkSetName(name);
        if (this.isCopy()) {
            this.myName = name;
            return this;
        }
        return PsiFileImplUtil.setName(this, name);
    }

    public void checkSetName(String name) throws IncorrectOperationException {
        if (this.isCopy()) {
            return;
        }
        PsiFileImplUtil.checkSetName(this, name);
    }

    public boolean isDirectory() {
        return false;
    }

    public PsiDirectory getContainingDirectory() {
        VirtualFile parentFile = this.getVirtualFile().getParent();
        if (parentFile == null) {
            return null;
        }
        return this.getManager().findDirectory(parentFile);
    }

    @Nullable
    public PsiDirectory getParentDirectory() {
        return this.getContainingDirectory();
    }

    public long getModificationStamp() {
        return this.myModificationStamp;
    }

    @NotNull
    public Language getLanguage() {
        return Language.ANY;
    }

    @Override
    public PsiManager getManager() {
        return this.myManager;
    }

    @NotNull
    public PsiElement[] getChildren() {
        return PsiElement.EMPTY_ARRAY;
    }

    public PsiDirectory getParent() {
        return this.getContainingDirectory();
    }

    @Override
    public PsiFile getContainingFile() {
        return this;
    }

    public TextRange getTextRange() {
        return null;
    }

    public int getStartOffsetInParent() {
        return -1;
    }

    public int getTextLength() {
        return -1;
    }

    public PsiElement findElementAt(int offset) {
        return null;
    }

    public int getTextOffset() {
        return -1;
    }

    public String getText() {
        return "";
    }

    @NotNull
    public char[] textToCharArray() {
        return ArrayUtil.EMPTY_CHAR_ARRAY;
    }

    @Override
    public boolean textMatches(@NotNull CharSequence text) {
        return false;
    }

    @Override
    public boolean textMatches(@NotNull PsiElement element) {
        return false;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        visitor.visitBinaryFile((PsiBinaryFile)this);
    }

    @Override
    public PsiElement copy() {
        PsiBinaryFileImpl clone = (PsiBinaryFileImpl)this.clone();
        clone.myName = this.getName();
        try {
            clone.myContents = !this.isCopy() ? this.getVirtualFile().contentsToByteArray() : this.myContents;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return clone;
    }

    private boolean isCopy() {
        return this.myName != null;
    }

    @Override
    public PsiElement add(@NotNull PsiElement element) throws IncorrectOperationException {
        throw new IncorrectOperationException();
    }

    @Override
    public PsiElement addBefore(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        throw new IncorrectOperationException();
    }

    @Override
    public PsiElement addAfter(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        throw new IncorrectOperationException();
    }

    @Override
    public void checkAdd(@NotNull PsiElement element) throws IncorrectOperationException {
        throw new IncorrectOperationException();
    }

    @Override
    public void delete() throws IncorrectOperationException {
        this.checkDelete();
        PsiFileImplUtil.doDelete(this);
    }

    @Override
    public void checkDelete() throws IncorrectOperationException {
        if (this.isCopy()) {
            throw new IncorrectOperationException();
        }
        CheckUtil.checkWritable((PsiElement)this);
    }

    @Override
    public PsiElement replace(@NotNull PsiElement newElement) throws IncorrectOperationException {
        return null;
    }

    @Override
    public boolean isValid() {
        if (this.isCopy()) {
            return true;
        }
        return this.getVirtualFile().isValid() && !this.myManager.getProject().isDisposed() && !this.myInvalidated;
    }

    @Override
    public boolean isWritable() {
        return this.isCopy() || this.getVirtualFile().isWritable();
    }

    @Override
    public boolean isPhysical() {
        return !this.isCopy();
    }

    @NotNull
    public PsiFile getOriginalFile() {
        return this;
    }

    @NonNls
    public String toString() {
        return "PsiBinaryFile:" + this.getName();
    }

    @NotNull
    public FileType getFileType() {
        return this.myViewProvider.getFileType();
    }

    @NotNull
    public PsiFile[] getPsiRoots() {
        return new PsiFile[]{this};
    }

    @NotNull
    public FileViewProvider getViewProvider() {
        return this.myViewProvider;
    }

    public FileASTNode getNode() {
        return null;
    }

    public void subtreeChanged() {
    }

    @Override
    public PsiElement getContext() {
        return FileContextUtil.getFileContext(this);
    }

    public void putInfo(@NotNull Map<String, String> info) {
        info.put("fileName", this.getName());
        info.put("fileType", this.getFileType().getName());
    }

    @Override
    public boolean isContentsLoaded() {
        return false;
    }

    @Override
    public void onContentReload() {
    }

    @Override
    public void markInvalidated() {
        this.myInvalidated = true;
        DebugUtil.onInvalidated(this);
    }
}

