/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.compiled;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.impl.compiled.ClsElementImpl;
import com.intellij.psi.impl.compiled.ClsTypeElementImpl;
import com.intellij.psi.impl.source.tree.TreeElement;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ClsReferenceParameterListImpl
extends ClsElementImpl
implements PsiReferenceParameterList {
    @NonNls
    private static final Pattern EXTENDS_PREFIX = Pattern.compile("^(\\?\\s*extends\\s*)(.*)");
    @NonNls
    private static final Pattern SUPER_PREFIX = Pattern.compile("^(\\?\\s*super\\s*)(.*)");
    private final PsiElement myParent;
    private final ClsTypeElementImpl[] myTypeParameters;
    private volatile PsiType[] myTypeParametersCachedTypes = null;

    public ClsReferenceParameterListImpl(PsiElement parent, String[] classParameters) {
        this.myParent = parent;
        int length = classParameters.length;
        this.myTypeParameters = new ClsTypeElementImpl[length];
        for (int i = 0; i < length; ++i) {
            String s = classParameters[length - i - 1];
            char variance = '\u0000';
            Matcher extendsMatcher = EXTENDS_PREFIX.matcher(s);
            if (extendsMatcher.find()) {
                variance = '+';
                s = extendsMatcher.group(2);
            } else {
                Matcher superMatcher = SUPER_PREFIX.matcher(s);
                if (superMatcher.find()) {
                    variance = '-';
                    s = superMatcher.group(2);
                } else if (StringUtil.startsWithChar((CharSequence)s, (char)'?')) {
                    variance = '*';
                    s = s.substring(1);
                }
            }
            this.myTypeParameters[i] = new ClsTypeElementImpl((PsiElement)this, s, variance);
        }
    }

    @Override
    public void appendMirrorText(int indentLevel, @NotNull StringBuilder buffer) {
    }

    @Override
    public void setMirror(@NotNull TreeElement element) throws ClsElementImpl.InvalidMirrorException {
    }

    @NotNull
    public PsiTypeElement[] getTypeParameterElements() {
        return this.myTypeParameters;
    }

    @NotNull
    public PsiType[] getTypeArguments() {
        PsiType[] cachedTypes = this.myTypeParametersCachedTypes;
        if (cachedTypes == null) {
            cachedTypes = PsiType.createArray((int)this.myTypeParameters.length);
            for (int i = 0; i < cachedTypes.length; ++i) {
                cachedTypes[cachedTypes.length - i - 1] = this.myTypeParameters[i].getType();
            }
            this.myTypeParametersCachedTypes = cachedTypes;
        }
        return cachedTypes;
    }

    @NotNull
    public PsiElement[] getChildren() {
        return this.myTypeParameters;
    }

    public PsiElement getParent() {
        return this.myParent;
    }
}

