/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.compiled;

import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.impl.compiled.ClsElementImpl;
import com.intellij.psi.impl.compiled.ClsJavaCodeReferenceElementImpl;
import com.intellij.psi.impl.compiled.ClsRepositoryPsiElement;
import com.intellij.psi.impl.java.stubs.PsiClassReferenceListStub;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.tree.TreeElement;
import org.jetbrains.annotations.NotNull;

public class ClsReferenceListImpl
extends ClsRepositoryPsiElement<PsiClassReferenceListStub>
implements PsiReferenceList {
    private static final ClsJavaCodeReferenceElementImpl[] EMPTY_REFS_ARRAY = new ClsJavaCodeReferenceElementImpl[0];
    private final NotNullLazyValue<ClsJavaCodeReferenceElementImpl[]> myRefs = new AtomicNotNullLazyValue<ClsJavaCodeReferenceElementImpl[]>(){

        @NotNull
        protected ClsJavaCodeReferenceElementImpl[] compute() {
            String[] strings = ((PsiClassReferenceListStub)ClsReferenceListImpl.this.getStub()).getReferencedNames();
            if (strings.length > 0) {
                ClsJavaCodeReferenceElementImpl[] refs = new ClsJavaCodeReferenceElementImpl[strings.length];
                for (int i = 0; i < strings.length; ++i) {
                    refs[i] = new ClsJavaCodeReferenceElementImpl((PsiElement)ClsReferenceListImpl.this, strings[i]);
                }
                return refs;
            }
            return EMPTY_REFS_ARRAY;
        }
    };

    public ClsReferenceListImpl(@NotNull PsiClassReferenceListStub stub) {
        super(stub);
    }

    @NotNull
    public PsiJavaCodeReferenceElement[] getReferenceElements() {
        return (PsiJavaCodeReferenceElement[])this.myRefs.getValue();
    }

    @Override
    @NotNull
    public PsiElement[] getChildren() {
        return this.getReferenceElements();
    }

    @NotNull
    public PsiClassType[] getReferencedTypes() {
        return ((PsiClassReferenceListStub)this.getStub()).getReferencedTypes();
    }

    public PsiReferenceList.Role getRole() {
        return ((PsiClassReferenceListStub)this.getStub()).getRole();
    }

    @Override
    public void appendMirrorText(int indentLevel, @NotNull StringBuilder buffer) {
        String[] names = ((PsiClassReferenceListStub)this.getStub()).getReferencedNames();
        if (names.length != 0) {
            PsiReferenceList.Role role = ((PsiClassReferenceListStub)this.getStub()).getRole();
            switch (role) {
                case EXTENDS_BOUNDS_LIST: 
                case EXTENDS_LIST: {
                    buffer.append("extends").append(' ');
                    break;
                }
                case IMPLEMENTS_LIST: {
                    buffer.append("implements").append(' ');
                    break;
                }
                case THROWS_LIST: {
                    buffer.append("throws").append(' ');
                }
            }
            for (int i = 0; i < names.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(names[i]);
            }
        }
    }

    @Override
    public void setMirror(@NotNull TreeElement element) throws ClsElementImpl.InvalidMirrorException {
        this.setMirrorCheckingType(element, null);
        ClsReferenceListImpl.setMirrors((PsiElement[])this.getReferenceElements(), (PsiElement[])((PsiReferenceList)SourceTreeToPsiMap.treeToPsiNotNull(element)).getReferenceElements());
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitReferenceList((PsiReferenceList)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public String toString() {
        return "PsiReferenceList";
    }
}

